/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.PersonaResourceRoleService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.PersonaResourceRole;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PersonaResourceRoleServiceImpl
extends BaseServiceImpl<PersonaResourceRole>
implements PersonaResourceRoleService {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    PersonaService personaService;
    @Inject
    ResourceService resourceService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_GET_BY_PERSONA)
    Instance<BoundStatement> stmtGetByPersonaInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_GET_BY_RESOURCE)
    Instance<BoundStatement> stmtGetByResourceInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_CREATE)
    Instance<BoundStatement> stmtCreateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_REMOVE)
    Instance<BoundStatement> stmtRemoveInstance;

    @Override
    PersonaResourceRole getFromRow(Row row) {
        Persona persona = this.personaService.getById(row.getUUID("persona"));
        Resource resource = this.resourceService.getById(row.getUUID("resource"));
        Role role = this.roleService.getById(row.getUUID("role"));
        PersonaResourceRole.Builder builder = new PersonaResourceRole.Builder();
        this.mapBaseFields(row, builder);
        return builder.persona(persona).resource(resource).role(role).build();
    }

    @Override
    public PersonaResourceRole getById(UUID id) {
        return (PersonaResourceRole)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    public PersonaResourceRole create(Persona persona, Resource resource, Role role) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        PersonaResourceRole prr = new PersonaResourceRole(persona, role, resource);
        this.bindBasicParameters(prr, stmtCreate);
        stmtCreate.setUUID("persona", persona.getIdAsUUID());
        stmtCreate.setUUID("resource", resource.getIdAsUUID());
        stmtCreate.setUUID("role", role.getIdAsUUID());
        this.session.execute((Statement)stmtCreate);
        this.logger.personaResourceRoleCreated(persona.getId(), resource.getId(), role.getName());
        return prr;
    }

    @Override
    public void remove(UUID id) {
        this.logger.personaResourceRoleRemoved(id.toString());
        this.session.execute((Statement)((BoundStatement)this.stmtRemoveInstance.get()).setUUID("id", id));
    }

    @Override
    public void remove(PersonaResourceRole personaResourceRole) {
        this.remove(personaResourceRole.getIdAsUUID());
        this.logger.personaResourceRoleRemoved(personaResourceRole.getPersona().getId(), personaResourceRole.getResource().getId(), personaResourceRole.getRole().getName());
    }

    @Override
    public List<PersonaResourceRole> getByPersona(Persona persona) {
        return this.getList(((BoundStatement)this.stmtGetByPersonaInstance.get()).setUUID("persona", persona.getIdAsUUID()));
    }

    @Override
    public List<PersonaResourceRole> getByPersonaAndResource(Persona persona, Resource resource) {
        return this.getByPersona(persona).stream().filter(prr -> prr.getResource().equals(resource)).collect(Collectors.toList());
    }

    @Override
    public List<PersonaResourceRole> getByResource(Resource resource) {
        return this.getList(((BoundStatement)this.stmtGetByResourceInstance.get()).setUUID("resource", resource.getIdAsUUID()));
    }
}

