/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.hawkular.accounts.api.AccessDeniedException;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaResourceRoleService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.PersonaResourceRole;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PersonaServiceImpl
implements PersonaService {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    OrganizationService organizationService;
    @Inject
    UserService userService;
    @Inject
    ResourceService resourceService;
    @Inject
    RoleService roleService;
    @Inject
    PersonaResourceRoleService personaResourceRoleService;
    @Inject
    private HttpServletRequest httpRequest;

    @Override
    public Persona getById(UUID id) {
        return this.get(id.toString());
    }

    @Override
    public Persona get(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The provided Persona ID is invalid (null).");
        }
        UUID uuid = UUID.fromString(id);
        Persona persona = this.userService.getById(uuid);
        if (null == persona) {
            persona = this.organizationService.getById(uuid);
        }
        return persona;
    }

    @Override
    public Set<Role> getEffectiveRolesForResource(Persona persona, Resource resource) {
        if (null == persona) {
            throw new IllegalArgumentException("Missing persona (null).");
        }
        if (null == resource) {
            throw new IllegalArgumentException("Missing resource (null).");
        }
        this.logger.determiningEffectiveRolesForPersonaOnResource(persona.getId(), resource.getId());
        List<PersonaResourceRole> results = this.personaResourceRoleService.getByPersonaAndResource(persona, resource);
        this.logger.numOfDirectRolesOnResource(persona.getId(), resource.getId(), results.size());
        if (results.size() == 0) {
            this.logger.noDirectRolesOnResource(persona.getId(), resource.getId());
            List<Organization> organizations = this.organizationService.getOrganizationsForPersona(persona);
            HashSet<Role> roles = new HashSet<Role>();
            for (Organization organization : organizations) {
                this.logger.checkingIndirectRolesViaOrganization(persona.getId(), resource.getId(), organization.getId());
                List<OrganizationMembership> memberships = this.membershipService.getPersonaMembershipsForOrganization(persona, organization);
                Set<Role> organizationRolesForResource = this.getEffectiveRolesForResource(organization, resource);
                Set effectiveRoles = memberships.stream().map(membership -> {
                    Set<Role> implicitRoles = this.roleService.getImplicitUserRoles(membership.getRole());
                    implicitRoles.add(membership.getRole());
                    return implicitRoles;
                }).flatMap(Collection::stream).filter(organizationRolesForResource::contains).collect(Collectors.toSet());
                this.logger.numOfEffectiveRolesViaOrganization(persona.getId(), resource.getId(), organization.getId(), effectiveRoles.size());
                roles.addAll(effectiveRoles);
            }
            this.logger.totalEffectiveRolesOnResource(persona.getId(), resource.getId(), roles.size());
            return roles;
        }
        HashSet<Role> roles = new HashSet<Role>(results.size());
        roles.addAll(results.stream().map(PersonaResourceRole::getRole).collect(Collectors.toSet()));
        roles.addAll(results.stream().map(r -> this.roleService.getImplicitUserRoles(r.getRole())).flatMap(Collection::stream).collect(Collectors.toSet()));
        this.logger.totalEffectiveRolesOnResourceWithImplicitRoles(persona.getId(), resource.getId(), roles.size());
        return roles;
    }

    @Override
    @Produces
    public Persona getCurrent() {
        String personaId = this.httpRequest.getHeader("Hawkular-Persona");
        if (personaId != null && !personaId.isEmpty()) {
            Persona persona = this.get(personaId);
            if (null == persona) {
                throw new AccessDeniedException("Invalid personaId [" + personaId + "].");
            }
            if (this.isAllowedToImpersonate(this.userService.getCurrent(), persona)) {
                return persona;
            }
            throw new AccessDeniedException("User is not allowed to impersonate this persona.");
        }
        return this.userService.getCurrent();
    }

    @Override
    public boolean isAllowedToImpersonate(HawkularUser actual, Persona toImpersonate) {
        if (actual.equals(toImpersonate)) {
            return true;
        }
        if (toImpersonate instanceof HawkularUser) {
            return false;
        }
        Resource resource = this.resourceService.getById(toImpersonate.getIdAsUUID());
        Set<Role> roles = this.getEffectiveRolesForResource(actual, resource);
        return roles != null && roles.size() > 0;
    }
}

