/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.security.Principal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.HawkularUser;
import org.keycloak.KeycloakPrincipal;

@Stateless
@PermitAll
public class UserServiceImpl
extends BaseServiceImpl<HawkularUser>
implements UserService {
    MsgLogger logger = MsgLogger.LOGGER;
    @Resource
    SessionContext sessionContext;
    @Inject
    @NamedStatement(value=BoundStatements.USER_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.USER_CREATE)
    Instance<BoundStatement> stmtCreateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.USER_UPDATE)
    Instance<BoundStatement> stmtUpdateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.USER_ALL)
    Instance<BoundStatement> stmtAllUsersInstance;

    @Override
    @Produces
    @CurrentUser
    public HawkularUser getCurrent() {
        Principal p = this.sessionContext.getCallerPrincipal();
        if (!(p instanceof KeycloakPrincipal)) {
            this.logger.nonAuthRequestWantsPersona();
            return null;
        }
        KeycloakPrincipal principal = (KeycloakPrincipal)p;
        String id = principal.getName();
        String name = principal.getKeycloakSecurityContext().getToken().getName();
        String email = principal.getKeycloakSecurityContext().getToken().getEmail();
        HawkularUser user = this.getOrCreateByIdAndName(id, name);
        boolean needsUpdate = false;
        if (!name.equals(user.getName())) {
            this.logger.settingUsersName(id, name, user.getName());
            user.setName(name);
            needsUpdate = true;
        }
        if (null != email && !email.equals(user.getEmail())) {
            this.logger.settingUsersEmail(id, email, user.getEmail());
            user.setEmail(email);
            needsUpdate = true;
        }
        if (needsUpdate) {
            return this.update(user);
        }
        return user;
    }

    @Override
    public HawkularUser getById(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public HawkularUser getById(UUID id) {
        return (HawkularUser)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    public HawkularUser getOrCreateById(String id) {
        HawkularUser user = this.getById(id);
        if (null == user) {
            this.logger.creatingUser(id);
            user = this.create(id, null);
        }
        return user;
    }

    @Override
    public HawkularUser getOrCreateByIdAndName(String id, String name) {
        HawkularUser user = this.getById(id);
        if (null == user) {
            this.logger.creatingUserWithName(id, name);
            user = this.create(id, name);
        }
        return user;
    }

    private HawkularUser create(UUID id, String name) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        HawkularUser user = new HawkularUser(id, name);
        this.bindBasicParameters(user, stmtCreate);
        stmtCreate.setString("name", user.getName());
        stmtCreate.setString("email", user.getEmail());
        this.session.execute((Statement)stmtCreate);
        return user;
    }

    private HawkularUser update(HawkularUser user) {
        return this.update(user, ((BoundStatement)this.stmtUpdateInstance.get()).setString("name", user.getName()).setString("email", user.getEmail()));
    }

    private HawkularUser create(String id, String name) {
        return this.create(UUID.fromString(id), name);
    }

    List<HawkularUser> getAll() {
        this.logger.listingAllUsers();
        return this.getList((BoundStatement)this.stmtAllUsersInstance.get());
    }

    @Override
    HawkularUser getFromRow(Row row) {
        HawkularUser.Builder builder = new HawkularUser.Builder();
        this.mapBaseFields(row, builder);
        return builder.name(row.getString("name")).email(row.getString("email")).build();
    }
}

