/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Map;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.NamedSetting;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.UserSettingsService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.UserSettings;

@Stateless
@PermitAll
public class UserSettingsServiceImpl
extends BaseServiceImpl<UserSettings>
implements UserSettingsService {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    @CurrentUser
    Instance<HawkularUser> userInstance;
    @Inject
    UserService userService;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_GET_BY_USER)
    Instance<BoundStatement> stmtGetByUserInstance;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_UPDATE)
    Instance<BoundStatement> stmtUpdateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_CREATE)
    Instance<BoundStatement> stmtCreateInstance;

    @Override
    public UserSettings get(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public UserSettings getById(UUID id) {
        return (UserSettings)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    public UserSettings getByUser() {
        return this.getByUser((HawkularUser)this.userInstance.get());
    }

    @Override
    public UserSettings getByUser(HawkularUser user) {
        return (UserSettings)this.getSingleRecord(((BoundStatement)this.stmtGetByUserInstance.get()).setUUID("persona", user.getIdAsUUID()));
    }

    @Override
    public UserSettings getOrCreateByUser() {
        return this.getOrCreateByUser((HawkularUser)this.userInstance.get());
    }

    @Override
    public UserSettings getOrCreateByUser(HawkularUser user) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            this.logger.creatingSettings(user.getId());
            settings = new UserSettings(user);
            this.bindBasicParameters(settings, stmtCreate);
            stmtCreate.setUUID("persona", user.getIdAsUUID());
            this.session.execute((Statement)stmtCreate);
        }
        return settings;
    }

    @Override
    public String getSettingByKey(String key) {
        return this.getSettingByKey((HawkularUser)this.userInstance.get(), key);
    }

    @Override
    public String getSettingByKey(String key, String defaultValue) {
        return this.getSettingByKey((HawkularUser)this.userInstance.get(), key, defaultValue);
    }

    @Override
    public String getSettingByKey(HawkularUser user, String key) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            return null;
        }
        return settings.get(key);
    }

    @Override
    public String getSettingByKey(HawkularUser user, String key, String defaultValue) {
        String value = this.getSettingByKey(user, key);
        return value == null ? defaultValue : value;
    }

    @Override
    public UserSettings store(HawkularUser user, String key, String value) {
        UserSettings settings = this.getOrCreateByUser(user);
        settings.put(key, value);
        this.update(settings, ((BoundStatement)this.stmtUpdateInstance.get()).setMap("properties", settings.getProperties()));
        this.logger.storedSetting(user.getId(), key, value);
        return settings;
    }

    @Override
    public UserSettings store(String key, String value) {
        return this.store((HawkularUser)this.userInstance.get(), key, value);
    }

    @Override
    public UserSettings remove(HawkularUser user, String key) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            return null;
        }
        settings.remove(key);
        this.update(settings, ((BoundStatement)this.stmtUpdateInstance.get()).setMap("properties", settings.getProperties()));
        this.logger.removedSetting(user.getId(), key);
        return settings;
    }

    @Override
    public UserSettings remove(String key) {
        return this.remove((HawkularUser)this.userInstance.get(), key);
    }

    @Override
    @Produces
    @NamedSetting
    public String produceSettingByName(InjectionPoint injectionPoint) {
        NamedSetting namedSetting = (NamedSetting)injectionPoint.getAnnotated().getAnnotation(NamedSetting.class);
        String setting = namedSetting.value();
        return this.getSettingByKey(setting);
    }

    @Override
    UserSettings getFromRow(Row row) {
        HawkularUser user = this.userService.getById(row.getUUID("persona"));
        Map properties = row.getMap("properties", String.class, String.class);
        UserSettings.Builder builder = new UserSettings.Builder();
        this.mapBaseFields(row, builder);
        return builder.user(user).properties(properties).build();
    }
}

