/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

public class PersonaResourceRole
extends BaseEntity {
    private Persona persona;
    private Role role;
    private Resource resource;

    public PersonaResourceRole(Persona persona, Role role, Resource resource) {
        this.persona = persona;
        this.role = role;
        this.resource = resource;
    }

    public PersonaResourceRole(String id, Persona persona, Role role, Resource resource) {
        super(id);
        this.persona = persona;
        this.role = role;
        this.resource = resource;
    }

    public PersonaResourceRole(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Persona persona, Role role, Resource resource) {
        super(id, createdAt, updatedAt);
        this.persona = persona;
        this.role = role;
        this.resource = resource;
    }

    public Persona getPersona() {
        return this.persona;
    }

    public Role getRole() {
        return this.role;
    }

    public Resource getResource() {
        return this.resource;
    }

    public static class Builder
    extends BaseEntity.Builder {
        private Persona persona;
        private Role role;
        private Resource resource;

        public Builder persona(Persona persona) {
            this.persona = persona;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public PersonaResourceRole build() {
            return new PersonaResourceRole(this.id, this.createdAt, this.updatedAt, this.persona, this.role, this.resource);
        }
    }
}

