/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Visibility;

public class Organization
extends Persona {
    private Persona owner;
    private String name;
    private String description;
    private Visibility visibility;

    public Organization(String id, Persona owner) {
        super(id);
        this.owner = owner;
    }

    public Organization(Persona owner) {
        super(UUID.randomUUID().toString());
        this.owner = owner;
    }

    public Organization(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Persona owner, String name, String description) {
        this(id, createdAt, updatedAt, owner, name, description, Visibility.PRIVATE);
    }

    public Organization(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Persona owner, String name, String description, Visibility visibility) {
        super(id, createdAt, updatedAt);
        this.owner = owner;
        this.name = name;
        this.description = description;
        this.visibility = visibility;
    }

    public Persona getOwner() {
        return this.owner;
    }

    public void setOwner(Persona owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public static class Builder
    extends BaseEntity.Builder {
        private Persona owner;
        private String name;
        private String description;
        private Visibility visibility;

        public Builder owner(Persona owner) {
            this.owner = owner;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder visibility(String visibility) {
            this.visibility = Visibility.valueOf(visibility);
            return this;
        }

        public Organization build() {
            return new Organization(this.id, this.createdAt, this.updatedAt, this.owner, this.name, this.description, this.visibility);
        }
    }
}

