/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;

public class BaseEntity
implements Serializable {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    private UUID id = UUID.randomUUID();
    private ZonedDateTime createdAt = ZonedDateTime.now();
    private ZonedDateTime updatedAt = ZonedDateTime.now();

    public BaseEntity() {
    }

    public BaseEntity(String id) {
        if (null != id) {
            this.id = !UUID_PATTERN.matcher(id).matches() ? UUID.nameUUIDFromBytes(id.getBytes()) : UUID.fromString(id);
        }
    }

    public BaseEntity(UUID id) {
        if (null != id) {
            this.id = id;
        }
    }

    public BaseEntity(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        if (null != id) {
            this.id = id;
        }
        if (null != createdAt) {
            this.createdAt = createdAt;
        }
        if (null != updatedAt) {
            this.updatedAt = updatedAt;
        }
    }

    @JsonIgnore
    public UUID getIdAsUUID() {
        return this.id;
    }

    public String getId() {
        return this.id.toString();
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt() {
        this.updatedAt = ZonedDateTime.now();
    }

    public String toString() {
        return "BaseEntity{id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEntity other = (BaseEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public static abstract class Builder {
        UUID id = UUID.randomUUID();
        ZonedDateTime createdAt = ZonedDateTime.now();
        ZonedDateTime updatedAt = ZonedDateTime.now();

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }
    }
}

