/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.Member;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Role;

public class OrganizationMembership
extends BaseEntity {
    private Organization organization;
    private Member member;
    private Role role;

    public OrganizationMembership(Organization organization, Member member, Role role) {
        this.organization = organization;
        this.member = member;
        this.role = role;
    }

    public OrganizationMembership(String id, Organization organization, Member member, Role role) {
        super(id);
        this.organization = organization;
        this.member = member;
        this.role = role;
    }

    public OrganizationMembership(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Organization organization, Member member, Role role) {
        super(id, createdAt, updatedAt);
        this.organization = organization;
        this.member = member;
        this.role = role;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Member getMember() {
        return this.member;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public static class Builder
    extends BaseEntity.Builder {
        private Organization organization;
        private Member member;
        private Role role;

        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public Builder member(Member member) {
            this.member = member;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public OrganizationMembership build() {
            return new OrganizationMembership(this.id, this.createdAt, this.updatedAt, this.organization, this.member, this.role);
        }
    }
}

