/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common;

import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.hawkular.accounts.common.AuthServerRequestExecutor;
import org.hawkular.accounts.common.AuthServerUrl;
import org.hawkular.accounts.common.RealmName;
import org.hawkular.accounts.common.UsernamePasswordConversionException;

@ApplicationScoped
public class UsernamePasswordConverter {
    @Inject
    @AuthServerUrl
    private String baseUrl;
    @Inject
    @RealmName
    private String realm;
    @Inject
    AuthServerRequestExecutor executor;

    public String getAccessToken(String username, String password) throws Exception {
        JsonObject response = this.getResponse(username, password);
        return response.getString("access_token");
    }

    public String getRefreshToken(String username, String password) throws Exception {
        JsonObject response = this.getResponse(username, password);
        return response.getString("refresh_token");
    }

    private JsonObject getResponse(String username, String password) throws Exception {
        String sResponse = this.getTokenResponseForUsernamePassword(username, password);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(sResponse));
        JsonObject object = jsonReader.readObject();
        if (object.get((Object)"error") != null) {
            String error = object.getString("error");
            throw new UsernamePasswordConversionException("Error from Keycloak server: " + error);
        }
        return object;
    }

    private String getTokenResponseForUsernamePassword(String username, String password) throws Exception {
        if (username == null || username.isEmpty()) {
            throw new UsernamePasswordConversionException("Username is not provided.");
        }
        String tokenUrl = this.baseUrl + "/realms/" + URLEncoder.encode(this.realm, "UTF-8") + "/protocol/openid-connect/token";
        String urlParameters = "grant_type=password&username=" + URLEncoder.encode(username, "UTF-8");
        urlParameters = urlParameters + "&password=" + URLEncoder.encode(password, "UTF-8");
        return this.executor.execute(tokenUrl, urlParameters, "POST");
    }
}

