/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.accounts.common.AuthServerHostSynonymService;
import org.hawkular.accounts.common.AuthServerRequestExecutor;
import org.hawkular.accounts.common.AuthServerUrl;
import org.hawkular.accounts.common.RealmName;
import org.keycloak.VerificationException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;

@ApplicationScoped
public class TokenVerifier {
    @Inject
    @AuthServerUrl
    private String baseUrl;
    @Inject
    @RealmName
    private String realm;
    @Inject
    private AuthServerHostSynonymService hostSynonymService;
    @Inject
    AuthServerRequestExecutor executor;

    public String verify(String token) throws Exception {
        AccessToken accessToken;
        JWSInput jwsInput;
        try {
            jwsInput = new JWSInput(token);
        }
        catch (Exception e) {
            throw new VerificationException("Couldn't parse token", (Throwable)e);
        }
        try {
            accessToken = (AccessToken)jwsInput.readJsonContent(AccessToken.class);
        }
        catch (IOException e) {
            throw new VerificationException("Couldn't parse token signature", (Throwable)e);
        }
        URL backendUrl = new URL(accessToken.getIssuer());
        URL baseUrlToCall = new URL(this.baseUrl);
        if (!backendUrl.getHost().equalsIgnoreCase(baseUrlToCall.getHost()) && this.hostSynonymService.isHostSynonym(backendUrl.getHost())) {
            baseUrlToCall = new URL(backendUrl.getProtocol(), backendUrl.getHost(), backendUrl.getPort(), baseUrlToCall.getPath());
        }
        String tokenUrl = baseUrlToCall.toString() + "/realms/" + URLEncoder.encode(this.realm, "UTF-8") + "/protocol/openid-connect/validate";
        String urlParameters = "access_token=" + URLEncoder.encode(token, "UTF-8");
        return this.executor.execute(tokenUrl, urlParameters, "GET");
    }
}

