/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common.internal;

import com.datastax.driver.core.Session;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.accounts.common.internal.CassandraSessionCallable;

@Startup
@Singleton
@ApplicationScoped
@PermitAll
public class CassandraSessionInitializer {
    private Future<Session> sessionFuture;
    @Resource
    private ManagedExecutorService executor;
    @Inject
    CassandraSessionCallable cassandraSessionCallable;

    @PostConstruct
    public void init() {
        this.sessionFuture = this.executor.submit((Callable)this.cassandraSessionCallable);
    }

    @Produces
    @ApplicationScoped
    public Session getSession() {
        try {
            return this.sessionFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Could not get the initialized session.");
        }
    }
}

