/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Base64;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.accounts.common.RealmResourceName;
import org.hawkular.accounts.common.RealmResourceSecret;
import org.hawkular.accounts.common.UsernamePasswordConversionException;
import org.hawkular.accounts.common.internal.MsgLogger;

@ApplicationScoped
public class AuthServerRequestExecutor {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    @RealmResourceName
    private String clientId;
    @Inject
    @RealmResourceSecret
    private String secret;

    public String execute(String url, String method) throws Exception {
        return this.execute(url, null, this.clientId, this.secret, method);
    }

    public String execute(String url, String urlParameters, String method) throws Exception {
        return this.execute(url, urlParameters, this.clientId, this.secret, method);
    }

    public String execute(String url, String clientId, String secret, String method) throws Exception {
        return this.execute(url, null, clientId, secret, method);
    }

    public String execute(String url, String urlParameters, String clientId, String secret, String method) throws Exception {
        InputStream inputStream;
        int statusCode;
        HttpURLConnection connection;
        this.logger.executingAuthServerRequest(url, clientId, method);
        String credentials = clientId + ":" + secret;
        String authorizationHeader = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
        if ("POST".equalsIgnoreCase(method)) {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod(method);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Authorization", authorizationHeader);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (null != urlParameters) {
                try (PrintWriter out = new PrintWriter(connection.getOutputStream());){
                    out.print(urlParameters);
                }
            }
        } else {
            connection = (HttpURLConnection)new URL(url + "?" + urlParameters).openConnection();
            connection.setRequestMethod(method);
            connection.setRequestProperty("Authorization", authorizationHeader);
        }
        int timeout = Integer.parseInt(System.getProperty("org.hawkular.accounts.http.timeout", "5000"));
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        StringBuilder response = new StringBuilder();
        try {
            statusCode = connection.getResponseCode();
            this.logger.requestExecuted(statusCode);
        }
        catch (SocketTimeoutException timeoutException) {
            throw new UsernamePasswordConversionException("Timed out when trying to contact the Keycloak server.");
        }
        if (statusCode < 300) {
            this.logger.statusCodeSuccess();
            inputStream = connection.getInputStream();
        } else {
            this.logger.statusCodeNotSuccess();
            inputStream = connection.getErrorStream();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        String responseAsString = response.toString();
        this.logger.responseBody(responseAsString);
        return responseAsString;
    }
}

