/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common;

import java.net.URLEncoder;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.accounts.common.AuthServerRequestExecutor;
import org.hawkular.accounts.common.AuthServerUrl;
import org.hawkular.accounts.common.RealmName;

@ApplicationScoped
public class TokenVerifier {
    @Inject
    @AuthServerUrl
    private String baseUrl;
    @Inject
    @RealmName
    private String realm;
    @Inject
    AuthServerRequestExecutor executor;

    public String verify(String token) throws Exception {
        String tokenUrl = this.baseUrl + "/realms/" + URLEncoder.encode(this.realm, "UTF-8") + "/protocol/openid-connect/token/introspect";
        String urlParameters = "token=" + URLEncoder.encode(token, "UTF-8");
        return this.executor.execute(tokenUrl, urlParameters, "POST");
    }
}

