/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.sample.boundary;

import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.sample.control.HawkularAccountsSample;
import org.hawkular.accounts.sample.entity.Sample;
import org.hawkular.accounts.sample.entity.SampleRequest;
import org.hawkular.accounts.sample.entity.Sample_;

@Path(value="/samples")
@PermitAll
@Stateless
public class SampleEndpoint {
    @Inject
    @HawkularAccountsSample
    EntityManager em;
    @Inject
    Persona currentPersona;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    ResourceService resourceService;
    @Inject
    @NamedOperation(value="sample-create")
    Operation operationCreate;
    @Inject
    @NamedOperation(value="sample-read")
    Operation operationRead;
    @Inject
    @NamedOperation(value="sample-update")
    Operation operationUpdate;
    @Inject
    @NamedOperation(value="sample-delete")
    Operation operationDelete;

    @GET
    public Response getAllSamples() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Sample.class);
        Root root = query.from(Sample.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Sample_.ownerId), (Object)this.currentPersona.getId()));
        return Response.ok().entity((Object)this.em.createQuery(query).getResultList()).build();
    }

    @GET
    @Path(value="{sampleId}")
    public Response getSample(@PathParam(value="sampleId") String sampleId) {
        Sample sample = (Sample)this.em.find(Sample.class, (Object)sampleId);
        if (this.permissionChecker.isAllowedTo(this.operationRead, sample.getId())) {
            return Response.ok().entity((Object)sample).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    public Response createSample(SampleRequest request) {
        Sample sample = new Sample(UUID.randomUUID().toString(), this.currentPersona.getId());
        this.resourceService.create(sample.getId(), this.currentPersona);
        sample.setName(request.getName());
        this.em.persist((Object)sample);
        return Response.ok().entity((Object)sample).build();
    }

    @DELETE
    @Path(value="{sampleId}")
    public Response removeSample(@PathParam(value="sampleId") String sampleId) {
        Sample sample = (Sample)this.em.find(Sample.class, (Object)sampleId);
        Resource resource = this.resourceService.get(sampleId);
        if (this.permissionChecker.isAllowedTo(this.operationDelete, resource)) {
            this.em.remove((Object)sample);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

