/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.secretstore.control;

import com.datastax.driver.core.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.accounts.secretstore.control.MsgLogger;

@Startup
@Singleton
@ApplicationScoped
@PermitAll
public class SecretStoreSchemaInitializer {
    MsgLogger logger = MsgLogger.LOGGER;
    @Resource
    private ManagedExecutorService executor;
    @Inject
    Session session;

    @PostConstruct
    public void init() {
        this.executor.submit(() -> {
            InputStream input = this.getClass().getResourceAsStream("/secret-store.cql");
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                for (String cql : content.split("(?m)^-- #.*$")) {
                    if (cql.startsWith("--")) continue;
                    this.session.execute(cql);
                }
            }
            catch (Exception e) {
                this.logger.failedToInitializeSchema((Throwable)e);
            }
        });
    }
}

