/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.secretstore.boundary;

import java.util.Base64;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.common.UsernamePasswordConverter;
import org.hawkular.accounts.secretstore.api.Token;
import org.hawkular.accounts.secretstore.api.TokenService;
import org.hawkular.accounts.secretstore.entity.TokenCreateResponse;
import org.hawkular.accounts.secretstore.entity.TokenErrorResponse;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

@Path(value="tokens")
@Stateless
@PermitAll
public class TokenEndpoint {
    @Resource
    SessionContext sessionContext;
    @Context
    HttpServletRequest request;
    @Context
    ServletContext servletContext;
    @Inject
    TokenService tokenService;
    @Inject
    UsernamePasswordConverter usernamePasswordConverter;

    @GET
    @Path(value="create")
    public Response createFromRedirect() {
        KeycloakPrincipal principal = (KeycloakPrincipal)this.sessionContext.getCallerPrincipal();
        RefreshableKeycloakSecurityContext kcSecurityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        String refreshToken = kcSecurityContext.getRefreshToken();
        return this.create(refreshToken);
    }

    @POST
    @Path(value="create")
    public Response createFromBasicAuth() throws Exception {
        String userAuthorizationHeader = this.request.getHeader("Authorization");
        String[] authorizationHeaderParts = userAuthorizationHeader.trim().split("\\s+");
        if (authorizationHeaderParts.length != 2) {
            TokenErrorResponse errorResponse = new TokenErrorResponse("Invalid authorization details.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        if (!authorizationHeaderParts[0].equalsIgnoreCase("Basic")) {
            TokenErrorResponse errorResponse = new TokenErrorResponse("Only 'Basic' authentication is supported.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        String authorization = new String(Base64.getDecoder().decode(authorizationHeaderParts[1]));
        String[] parts = authorization.split(":");
        String username = parts[0];
        String password = parts[1];
        if (username == null || username.isEmpty()) {
            TokenErrorResponse errorResponse = new TokenErrorResponse("Username is not provided.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        String refreshToken = this.usernamePasswordConverter.getOfflineToken(username, password);
        return this.create(refreshToken);
    }

    private Response create(String refreshToken) {
        Token token = new Token(null, refreshToken);
        String personaId = this.request.getHeader("Hawkular-Persona");
        if (null != personaId && !personaId.isEmpty()) {
            token.addAttribute("persona_id", personaId);
        }
        this.tokenService.create(token);
        return Response.ok((Object)new TokenCreateResponse(token)).build();
    }
}

