/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.backend.entity.rest.ErrorResponse;
import org.hawkular.accounts.backend.entity.rest.OrganizationMembershipUpdateRequest;

@Path(value="/organizationMemberships")
@PermitAll
@Stateless
public class OrganizationMembershipEndpoint {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    OrganizationService organizationService;
    @Inject
    RoleService roleService;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    @NamedOperation(value="organization-change-role-of-members")
    Operation changeMemberRole;

    @GET
    @Path(value="/{membershipId}")
    public Response getMembership(@PathParam(value="membershipId") String membershipId) {
        if (null == membershipId || membershipId.isEmpty()) {
            String message = "The given membership ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        OrganizationMembership membership = this.membershipService.getMembershipById(membershipId);
        if (null == membership) {
            String message = "The specified membership is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        return Response.ok().entity((Object)membership).build();
    }

    @GET
    public Response getOrganizationMembershipsForOrganization(@QueryParam(value="organizationId") String organizationId) {
        Organization organization = this.organizationService.get(organizationId);
        List memberships = this.membershipService.getMembershipsForOrganization(organization);
        return Response.ok().entity((Object)memberships).build();
    }

    @PUT
    @Path(value="{membershipId}")
    public Response updateMembership(@PathParam(value="membershipId") String membershipId, @NotNull OrganizationMembershipUpdateRequest request) {
        if (null == membershipId || membershipId.isEmpty()) {
            String message = "The given membership ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        if (null == request.getRole() || null == request.getRole().getName()) {
            String message = "The given role is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        OrganizationMembership membership = this.membershipService.getMembershipById(membershipId);
        Role role = this.roleService.getByName(request.getRole().getName());
        if (null == membership) {
            String message = "The specified membership is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        if (null == role) {
            String message = "The specified role is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        if (!this.permissionChecker.isAllowedTo(this.changeMemberRole, membership.getOrganization().getId())) {
            String message = "Insufficient permissions to change the role of users of this organization.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorResponse(message)).build();
        }
        membership = this.membershipService.changeRole(membership, role);
        return Response.ok((Object)membership).build();
    }
}

