/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;

@Path(value="/roles")
@PermitAll
@Stateless
public class RoleEndpoint {
    @Inject
    Persona persona;
    @Inject
    PersonaService personaService;
    @Inject
    ResourceService resourceService;

    @GET
    public Response getRoleForResource(@QueryParam(value="resourceId") String resourceId) {
        if (null == resourceId) {
            String message = "The given resource ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        Resource resource = this.resourceService.get(resourceId);
        Set roles = this.personaService.getEffectiveRolesForResource(this.persona, resource);
        return Response.ok((Object)roles).build();
    }
}

