/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.UserSettingsService;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.UserSettings;

@Path(value="/settings")
@PermitAll
@Stateless
public class UserSettingsEndpoint {
    @Inject
    UserSettingsService service;
    @Inject
    @CurrentUser
    HawkularUser user;

    @GET
    public Response getByUser() {
        UserSettings settings = this.service.getOrCreateByUser(this.user);
        return Response.ok((Object)settings.getProperties()).build();
    }

    @PUT
    public Response storeKey(Map<String, String> properties) {
        properties.forEach((key, value) -> this.service.store(this.user, key, value));
        UserSettings settings = this.service.getByUser(this.user);
        return Response.ok((Object)settings.getProperties()).build();
    }
}

