/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.control;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.backend.control.MsgLogger;

public class SetupHawkularAccountsImpl
implements ServletContextListener {
    private final MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    RoleService roleService;
    @Inject
    @HawkularAccounts
    EntityManager entityManager;
    @Inject
    OperationService operationService;
    @Resource
    UserTransaction tx;
    Set<Role> roles = new HashSet(7);
    Role monitor = new Role("Monitor", "Has the fewest permissions. Only read configuration and current runtime state, No access to sensitive resources or data or audit logging resources");
    Role operator = new Role("Operator", "All permissions of Monitor. Can modify the runtime state, e.g. reload or shutdown the server, pause/resume JMS destination, flush database connection pool. Does not have permission to modify persistent state.");
    Role maintainer = new Role("Maintainer", "All permissions of Operator. Can modify the persistent state, e.g. deploy an application, setting up new data sources, add a JMS destination");
    Role deployer = new Role("Deployer", "All permissions of Maintainer. Permission is restricted to applications only, cannot make changes to container configuration");
    Role administrator = new Role("Administrator", "All permissions of Maintainer. View and modify sensitive data such as access control system.  No access to administrative audit logging system.");
    Role auditor = new Role("Auditor", "All permissions of Monitor. View and modify resources to administrative audit logging system. Cannot modify sensitive resources or data outside auditing, can read any sensitive data");
    Role superUser = new Role("SuperUser", "Has all the permissions. Equivalent to administrator in previous versions.");

    public void contextInitialized(ServletContextEvent servletContextEvent) throws RuntimeException {
        try {
            this.tx.begin();
            this.setup();
            this.tx.commit();
        }
        catch (Exception e) {
            try {
                this.tx.rollback();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void setup() {
        this.logger.infoStartedSetupAccounts();
        this.roles.add(this.monitor);
        this.roles.add(this.operator);
        this.roles.add(this.maintainer);
        this.roles.add(this.deployer);
        this.roles.add(this.administrator);
        this.roles.add(this.auditor);
        this.roles.add(this.superUser);
        this.roles.stream().forEach(arg_0 -> this.addRoleIfDoesntExists(arg_0));
        this.operationService.setup("organization-create").add("Monitor").persist().setup("organization-read").add("Maintainer").persist().setup("organization-delete").add("SuperUser").persist().setup("organization-update").add("Maintainer").persist().setup("organization-invite").add("Administrator").persist().setup("organization-list-invitations").add("Administrator").persist().setup("organization-change-role-of-members").add("Administrator").persist().setup("organization-transfer").add("SuperUser").persist();
        this.logger.infoFinishedSetupAccounts();
    }

    private void addRoleIfDoesntExists(Role role) {
        if (null == this.roleService.getByName(role.getName())) {
            this.entityManager.persist((Object)role);
        }
        this.entityManager.flush();
    }
}

