/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.OrganizationJoinRequestService;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.JoinRequestStatus;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationJoinRequest;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.api.model.Visibility;
import org.hawkular.accounts.backend.control.MsgLogger;
import org.hawkular.accounts.backend.entity.OrganizationJoinRequestEvent;
import org.hawkular.accounts.backend.entity.rest.ErrorResponse;
import org.hawkular.accounts.backend.entity.rest.OrganizationJoinRequestDecisionRequest;

@Path(value="/organizationJoinRequests")
@PermitAll
@Stateless
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class OrganizationJoinEndpoint {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    @CurrentUser
    Instance<HawkularUser> userInstance;
    @Inject
    Instance<Persona> personaInstance;
    @Inject
    OrganizationJoinRequestService joinRequestService;
    @Inject
    OrganizationService organizationService;
    @Inject
    Event<OrganizationJoinRequestEvent> event;
    @Inject
    @NamedOperation(value="organization-join-request-decision")
    Operation operationDecision;
    @Inject
    @NamedOperation(value="organization-read")
    Operation operationRead;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    @NamedRole(value="Monitor")
    Role monitor;
    @Inject
    OrganizationMembershipService membershipService;

    @Path(value="/{organizationId}")
    @POST
    public Response applyToJoin(@PathParam(value="organizationId") String organizationId) {
        if (null == organizationId || organizationId.isEmpty()) {
            this.logger.missingOrganization();
            ErrorResponse response = new ErrorResponse("Invalid organization (null)");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        Organization organization = this.organizationService.getById(UUID.fromString(organizationId));
        if (null == organization) {
            this.logger.organizationNotFound(organizationId);
            ErrorResponse response = new ErrorResponse("Organization not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
        }
        if (this.membershipService.getPersonaMembershipsForOrganization((Persona)this.personaInstance.get(), organization).size() > 0) {
            this.logger.alreadyMemberOfOrganization(((Persona)this.personaInstance.get()).getId(), organizationId);
            ErrorResponse response = new ErrorResponse("You are already a member of the requested organization.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        if (organization.getVisibility().equals((Object)Visibility.PRIVATE)) {
            this.logger.privateOrganizationCannotAcceptJoinRequests(((Persona)this.personaInstance.get()).getId(), organizationId);
            ErrorResponse response = new ErrorResponse("This organization doesn't accept applications. You need to be invited in order to join this organization.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
        }
        OrganizationJoinRequest request = this.joinRequestService.create(organization, (Persona)this.userInstance.get());
        this.event.fire((Object)new OrganizationJoinRequestEvent(request));
        this.logger.joinRequestCreated(((Persona)this.personaInstance.get()).getId(), organizationId);
        return Response.ok((Object)request).build();
    }

    @Path(value="/{organizationId}")
    @PUT
    public Response requestDecision(OrganizationJoinRequestDecisionRequest request, @PathParam(value="organizationId") String organizationId) {
        Persona persona;
        if (null == organizationId || organizationId.isEmpty()) {
            this.logger.missingOrganization();
            ErrorResponse response = new ErrorResponse("Invalid organization (null)");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        if (null == request.getDecision() || request.getDecision().isEmpty()) {
            this.logger.missingDecision();
            ErrorResponse response = new ErrorResponse("Invalid decision (null)");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        OrganizationJoinRequest joinRequest = this.joinRequestService.getById(UUID.fromString(request.getJoinRequestId()));
        if (null == joinRequest) {
            this.logger.joinRequestNotFound(request.getJoinRequestId());
            ErrorResponse response = new ErrorResponse("Join request not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
        }
        if (!joinRequest.getOrganization().getIdAsUUID().toString().equals(organizationId)) {
            this.logger.joinRequestBelongsToAnotherCompany(((Persona)this.personaInstance.get()).getId(), organizationId, joinRequest.getOrganization().getId());
            ErrorResponse response = new ErrorResponse("Organization mismatch: the join request doesn't belong to this organization.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        if (!joinRequest.getStatus().equals((Object)JoinRequestStatus.PENDING)) {
            this.logger.joinRequestAlreadyDecidedUpon(((Persona)this.personaInstance.get()).getId(), joinRequest.getId());
            if (request.getDecision().toUpperCase().equals("ACCEPT") && joinRequest.getStatus().equals((Object)JoinRequestStatus.ACCEPTED)) {
                ErrorResponse response = new ErrorResponse("The join request has already been previously accepted.");
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)response).build();
            }
            if (request.getDecision().toUpperCase().equals("REJECT") && joinRequest.getStatus().equals((Object)JoinRequestStatus.REJECTED)) {
                ErrorResponse response = new ErrorResponse("The join request has already been previously rejected.");
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)response).build();
            }
            ErrorResponse response = new ErrorResponse("A different decision has already been made about this join request.");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)response).build();
        }
        String resourceId = joinRequest.getIdAsUUID().toString();
        if (!this.permissionChecker.isAllowedTo(this.operationDecision, resourceId, persona = (Persona)this.personaInstance.get())) {
            this.logger.notAllowedToPerformOperationOnResource(this.operationDecision.getName(), resourceId, persona.getId());
            ErrorResponse response = new ErrorResponse("Insufficient permissions to accept/reject a request on this organization.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
        }
        List memberships = this.membershipService.getPersonaMembershipsForOrganization(joinRequest.getPersona(), joinRequest.getOrganization());
        if (memberships.size() > 0) {
            this.logger.alreadyMemberOfOrganization(persona.getId(), organizationId);
            ErrorResponse response = new ErrorResponse("The persona who requested access is already a member of the organization. Marking the request as REJECTED.");
            joinRequest = this.joinRequestService.reject(joinRequest);
            this.event.fire((Object)new OrganizationJoinRequestEvent(joinRequest));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        switch (request.getDecision().toUpperCase()) {
            case "ACCEPT": {
                joinRequest = this.joinRequestService.accept(joinRequest, this.monitor);
                break;
            }
            case "REJECT": {
                joinRequest = this.joinRequestService.reject(joinRequest);
                break;
            }
            default: {
                this.logger.unknownDecision(request.getDecision());
                ErrorResponse response = new ErrorResponse("Invalid decision: " + request.getDecision());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
            }
        }
        this.logger.decisionMade(joinRequest.getId(), request.getDecision());
        this.event.fire((Object)new OrganizationJoinRequestEvent(joinRequest));
        return Response.ok((Object)joinRequest).build();
    }

    @Path(value="/{organizationId}")
    @GET
    public Response list(@PathParam(value="organizationId") String organizationId, @QueryParam(value="filter") String filter) {
        List requests;
        Organization organization;
        if (null == organizationId || organizationId.isEmpty()) {
            this.logger.missingOrganization();
            ErrorResponse response = new ErrorResponse("Invalid organization (null)");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        if (!this.permissionChecker.isAllowedTo(this.operationRead, organizationId, (Persona)this.personaInstance.get())) {
            this.logger.notAllowedToPerformOperationOnResource(this.operationRead.getName(), organizationId, ((Persona)this.personaInstance.get()).getId());
            ErrorResponse response = new ErrorResponse("Insufficient permissions to see join requests for this organization.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
        }
        boolean onlyPending = true;
        if (null != filter && !filter.isEmpty()) {
            onlyPending = false;
        }
        if (null == (organization = this.organizationService.getById(UUID.fromString(organizationId)))) {
            this.logger.organizationNotFound(organizationId);
            ErrorResponse response = new ErrorResponse("Organization not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
        }
        if (onlyPending) {
            this.logger.listOnlyPendingJoinRequests();
            requests = this.joinRequestService.getPendingRequestsForOrganization(organization);
        } else {
            this.logger.listAllJoinRequests();
            requests = this.joinRequestService.getAllRequestsForOrganization(organization);
        }
        return Response.ok((Object)requests).build();
    }

    @Path(value="/")
    @GET
    public Response listOwnRequests() {
        List joinRequests = this.joinRequestService.getAllRequestsForPersona((Persona)this.personaInstance.get());
        this.logger.listAllJoinRequestsForPersona(((Persona)this.personaInstance.get()).getId(), joinRequests.size());
        joinRequests = joinRequests.stream().filter(j -> !j.getStatus().equals((Object)JoinRequestStatus.ACCEPTED)).collect(Collectors.toList());
        this.logger.listPendingJoinRequestsForPersona(((Persona)this.personaInstance.get()).getId(), joinRequests.size());
        return Response.ok(joinRequests).build();
    }
}

