/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.control;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationJoinRequest;
import org.hawkular.accounts.backend.control.JoinRequestNotificationDispatcher;
import org.hawkular.accounts.backend.control.MsgLogger;
import org.hawkular.accounts.backend.entity.OrganizationJoinRequestEvent;
import org.hawkular.commons.email.EmailDispatcher;

@PermitAll
@Singleton
public class JoinRequestNotificationDispatcher {
    public static final String HAWKULAR_BASE_URL = "HAWKULAR_BASE_URL";
    public static final String DEFAULT_HAWKULAR_BASE_URL = System.getenv("HAWKULAR_BASE_URL") == null ? "http://localhost:8080/" : System.getenv("HAWKULAR_BASE_URL");
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    EmailDispatcher emailDispatcher;
    @Inject
    InvitationService invitationService;

    public void dispatchNotification(@Observes OrganizationJoinRequestEvent event) {
        OrganizationJoinRequest request = event.getRequest();
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("requestor", request.getPersona().getName());
        properties.put("orgName", request.getOrganization().getName());
        properties.put("pendingRequestsUrl", DEFAULT_HAWKULAR_BASE_URL + "/hawkular-ui/organization/" + request.getOrganization().getIdAsUUID().toString() + "/memberships");
        switch (1.$SwitchMap$org$hawkular$accounts$api$model$JoinRequestStatus[request.getStatus().ordinal()]) {
            case 1: {
                this.sendNotificationsForPending(request, properties);
                break;
            }
            case 2: {
                this.sendNotificationsForRejected(request, properties);
                break;
            }
            case 3: {
                this.sendNotificationsForAccepted(request, properties);
            }
        }
    }

    private void sendNotificationsForAccepted(OrganizationJoinRequest request, Map<String, Object> properties) {
        if (!(request.getPersona() instanceof HawkularUser)) {
            this.logger.joinRequestToOrganization();
            return;
        }
        HawkularUser user = (HawkularUser)request.getPersona();
        String email = user.getEmail();
        if (null == email || email.isEmpty()) {
            this.logger.joinRequestUserEmailIsEmpty();
            return;
        }
        try {
            this.emailDispatcher.dispatch(new InternetAddress(email), "[hawkular] - You have been accepted to join " + request.getOrganization().getName(), "join_request_approved_plain.ftl", "join_request_approved_html.ftl", properties);
        }
        catch (Exception e) {
            this.logger.joinRequestFailToSendAcceptedNotification(request.getId(), (Throwable)e);
        }
    }

    private void sendNotificationsForRejected(OrganizationJoinRequest request, Map<String, Object> properties) {
        if (!(request.getPersona() instanceof HawkularUser)) {
            this.logger.joinRequestToOrganization();
            return;
        }
        HawkularUser user = (HawkularUser)request.getPersona();
        String email = user.getEmail();
        if (null == email || email.isEmpty()) {
            this.logger.joinRequestUserEmailIsEmpty();
            return;
        }
        try {
            this.emailDispatcher.dispatch(new InternetAddress(email), "[hawkular] - Join request declined", "join_request_rejected_plain.ftl", "join_request_rejected_html.ftl", properties);
        }
        catch (Exception e) {
            this.logger.joinRequestFailToSendRejectedNotification(request.getId(), (Throwable)e);
        }
    }

    private void sendNotificationsForPending(OrganizationJoinRequest request, Map<String, Object> properties) {
        if (!(request.getPersona() instanceof HawkularUser)) {
            this.logger.joinRequestToOrganization();
            return;
        }
        HawkularUser user = (HawkularUser)request.getPersona();
        String email = user.getEmail();
        HawkularUser owner = this.getOwnerForOrganization(request.getOrganization());
        String ownersEmail = owner.getEmail();
        try {
            if (null == ownersEmail || ownersEmail.isEmpty()) {
                this.logger.joinRequestOwnersEmailIsEmpty();
            } else {
                this.emailDispatcher.dispatch(new InternetAddress(ownersEmail), "[hawkular] - Join request for " + request.getOrganization().getName(), "join_request_to_admin_plain.ftl", "join_request_to_admin_html.ftl", properties);
            }
            if (null == email || email.isEmpty()) {
                this.logger.joinRequestUserEmailIsEmpty();
            } else {
                this.emailDispatcher.dispatch(new InternetAddress(email), "[hawkular] - Join request for " + request.getOrganization().getName(), "join_request_to_requestor_plain.ftl", "join_request_to_requestor_html.ftl", properties);
            }
        }
        catch (Exception e) {
            this.logger.joinRequestFailToSendNotification(request.getId(), (Throwable)e);
        }
    }

    private HawkularUser getOwnerForOrganization(Organization organization) {
        if (organization.getOwner() instanceof HawkularUser) {
            return (HawkularUser)organization.getOwner();
        }
        return this.getOwnerForOrganization((Organization)organization.getOwner());
    }
}

