/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.backend.control.MsgLogger;
import org.hawkular.accounts.backend.entity.rest.ErrorResponse;
import org.hawkular.accounts.backend.entity.rest.PermissionResponse;

@Path(value="/permissions")
@PermitAll
@Stateless
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PermissionEndpoint {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    OperationService operationService;
    @Inject
    ResourceService resourceService;
    @Inject
    Instance<Persona> personaInstance;

    @GET
    public Response isAllowedTo(@QueryParam(value="operation") String operationName, @QueryParam(value="resourceId") String resourceId) {
        if (null == resourceId) {
            this.logger.missingResource();
            String message = "The given resource ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        if (null == operationName || operationName.isEmpty()) {
            this.logger.missingOperation();
            String message = "The given operation name is invalid (null or empty).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        Resource resource = this.resourceService.get(resourceId);
        if (null == resource) {
            this.logger.resourceNotFound(resourceId);
            String message = "The given resource ID is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        Operation operation = this.operationService.getByName(operationName);
        if (null == operation) {
            this.logger.operationNotFound(operationName);
            String message = "The given operation is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        boolean isAllowedTo = this.permissionChecker.isAllowedTo(operation, resource);
        PermissionResponse response = new PermissionResponse(isAllowedTo);
        this.logger.permissionResponsePrepared(operationName, resourceId, ((Persona)this.personaInstance.get()).getId(), isAllowedTo);
        return Response.ok((Object)response).build();
    }
}

