/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.ArrayList;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Persona;

@Path(value="/personas")
@PermitAll
@Stateless
public class PersonaEndpoint {
    @Inject
    Instance<Persona> personaInstance;
    @Inject
    @CurrentUser
    Instance<HawkularUser> userInstance;
    @Inject
    OrganizationService organizationService;

    @GET
    @Path(value="/")
    public Response getPersonas() {
        HawkularUser user = (HawkularUser)this.userInstance.get();
        ArrayList<HawkularUser> personas = new ArrayList<HawkularUser>();
        personas.addAll(this.organizationService.getOrganizationsForPersona((Persona)user));
        personas.add(user);
        return Response.ok().entity(personas).build();
    }

    @GET
    @Path(value="/current")
    public Response getCurrentPersona() {
        return Response.ok().entity(this.personaInstance.get()).build();
    }
}

