/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.OrganizationJoinRequestService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Visibility;
import org.hawkular.accounts.backend.control.MsgLogger;
import org.hawkular.accounts.backend.entity.rest.ErrorResponse;
import org.hawkular.accounts.backend.entity.rest.OrganizationRequest;
import org.hawkular.accounts.backend.entity.rest.OrganizationTransferRequest;

@Path(value="/organizations")
@PermitAll
@Stateless
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class OrganizationEndpoint {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    Instance<Persona> personaInstance;
    @Inject
    @CurrentUser
    Instance<HawkularUser> userInstance;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    @NamedOperation(value="organization-create")
    Operation operationCreate;
    @Inject
    @NamedOperation(value="organization-read")
    Operation operationRead;
    @Inject
    @NamedOperation(value="organization-update")
    Operation operationUpdate;
    @Inject
    @NamedOperation(value="organization-delete")
    Operation operationDelete;
    @Inject
    @NamedOperation(value="organization-transfer")
    Operation operationTransfer;
    @Inject
    ResourceService resourceService;
    @Inject
    OrganizationService organizationService;
    @Inject
    PersonaService personaService;
    @Inject
    OrganizationJoinRequestService joinRequestService;

    @GET
    @Path(value="/")
    public Response getOrganizationsForPersona() {
        Persona persona = (Persona)this.personaInstance.get();
        List organizations = this.organizationService.getOrganizationsForPersona(persona);
        this.logger.numberOfOrganizationsForPersona(persona.getId(), organizations.size());
        List filteredOrganizations = organizations.stream().filter(o -> this.permissionChecker.isAllowedTo(this.operationRead, o.getId(), persona)).collect(Collectors.toList());
        this.logger.filteredOrganizationsWithReadPermission(persona.getId(), organizations.size());
        return Response.ok().entity(filteredOrganizations).build();
    }

    @GET
    @Path(value="/join")
    public Response getOrganizationsToJoin() {
        Persona persona = (Persona)this.personaInstance.get();
        List organizationsToJoin = this.organizationService.getFilteredOrganizationsToJoin(persona);
        this.logger.filteredOrganizationsToJoin(persona.getId(), organizationsToJoin.size());
        return Response.ok().entity((Object)organizationsToJoin).build();
    }

    @POST
    @Path(value="/")
    public Response createOrganization(@NotNull OrganizationRequest request) {
        HawkularUser user;
        Persona persona = (Persona)this.personaInstance.get();
        if (!persona.equals((Object)(user = (HawkularUser)this.userInstance.get()))) {
            this.logger.organizationTryingToCreateOrganization(persona.getId());
            String message = "Organizations cannot create sub-organizations.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)message).build();
        }
        if (request.getName() == null || request.getName().isEmpty()) {
            this.logger.missingOrganizationName();
            String message = "Missing organization name.";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        if (null != this.organizationService.getByName(request.getName())) {
            this.logger.duplicateOrganizationName();
            ErrorResponse response = new ErrorResponse("There's already an organization with this name");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        Visibility visibility = null;
        for (Visibility value : Visibility.values()) {
            if (!value.name().equalsIgnoreCase(request.getVisibility())) continue;
            visibility = value;
        }
        if (null == visibility) {
            this.logger.missingVisibility();
            ErrorResponse response = new ErrorResponse("Visibility is invalid. Possible values: " + Arrays.toString(Visibility.values()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        Organization organization = this.organizationService.createOrganization(request.getName(), request.getDescription(), visibility, persona);
        this.logger.createdOrganization(organization.getId(), organization.getName(), organization.getVisibility().name());
        return Response.ok().entity((Object)organization).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteOrganization(@NotNull @PathParam(value="id") String id) {
        Organization organization = this.organizationService.get(id);
        List subOrganizations = this.organizationService.getSubOrganizations(organization);
        if (subOrganizations.size() > 0) {
            this.logger.organizationHasSuborganizations(organization.getId());
            ErrorResponse response = new ErrorResponse("This organization has sub-organizations. Please, remove those before removing this organization.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        List resources = this.resourceService.getByPersona((Persona)organization);
        if (resources.size() > 0) {
            this.logger.organizationHasResources(organization.getId());
            ErrorResponse response = new ErrorResponse("This organization is the owner of resources. Please, remove or transfer those resources before removing this organization.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        if (this.permissionChecker.isAllowedTo(this.operationDelete, id, (Persona)this.personaInstance.get())) {
            this.logger.organizationRemoved(organization.getId());
            this.organizationService.deleteOrganization(organization);
            return Response.ok().build();
        }
        this.logger.notAllowedToPerformOperationOnResource(this.operationDelete.getName(), id, ((Persona)this.personaInstance.get()).getId());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="/{id}")
    public Response getOrganization(@PathParam(value="id") String id) {
        Organization organization = this.organizationService.get(id);
        if (organization == null) {
            this.logger.organizationNotFound(id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.permissionChecker.isAllowedTo(this.operationRead, organization.getId(), (Persona)this.personaInstance.get())) {
            this.logger.notAllowedToPerformOperationOnResource(this.operationRead.getName(), id, ((Persona)this.personaInstance.get()).getId());
            String message = "The specified organization could not be found for this persona.";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        this.logger.organizationFound(id);
        return Response.ok().entity((Object)organization).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response transferOrganization(@PathParam(value="id") String id, OrganizationTransferRequest request) {
        if (null == id || id.isEmpty()) {
            this.logger.missingOrganization();
            String message = "The given organization ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        if (null == request || null == request.getOwner() || request.getOwner().getId().isEmpty()) {
            this.logger.missingUser();
            String message = "The given user ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        Organization organization = this.organizationService.get(id);
        Persona newOwner = this.personaService.get(request.getOwner().getId());
        if (null == organization) {
            this.logger.organizationNotFound(id);
            String message = "The specified organization is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        if (null == newOwner) {
            this.logger.userNotFound(request.getOwner().getId());
            String message = "The specified new owner is invalid (not found).";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        if (!this.permissionChecker.isAllowedTo(this.operationTransfer, organization.getId())) {
            this.logger.notAllowedToPerformOperationOnResource(this.operationTransfer.getName(), id, ((Persona)this.personaInstance.get()).getId());
            String message = "Insufficient permissions to change the role of users of this organization.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorResponse(message)).build();
        }
        this.organizationService.transfer(organization, newOwner);
        this.logger.organizationTransferred(organization.getId(), newOwner.getId());
        return Response.ok().entity((Object)organization).build();
    }
}

