/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.helloworld;

import java.lang.management.ManagementFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hawkular.agent.helloworld.SimpleMXBean;

@ApplicationScoped
public class SimpleMXBeanImpl
implements SimpleMXBean {
    public static final String OBJECT_NAME = "org.hawkular.agent.itest:type=simple";
    private Integer i = new Integer(54321);

    @PostConstruct
    protected void register() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = new ObjectName(OBJECT_NAME);
            mbs.registerMBean(this, on);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register the SimplMXBean");
        }
    }

    @PreDestroy
    protected void unregister() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = new ObjectName(OBJECT_NAME);
            mbs.unregisterMBean(on);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unregister the SimplMXBean");
        }
    }

    public String getTestString() {
        return "Hello World";
    }

    public int getTestIntegerPrimitive() {
        return 12345;
    }

    public Integer getTestInteger() {
        return this.i;
    }

    public void setTestInteger(Integer i) {
        this.i = i;
    }

    public boolean getTestBooleanPrimitive() {
        return false;
    }

    public Boolean getTestBoolean() {
        return true;
    }

    public long getTestLongPrimitive() {
        return 123456789L;
    }

    public Long getTestLong() {
        return 987654321L;
    }

    public double getTestDoublePrimitive() {
        return 1.23456789;
    }

    public Double getTestDouble() {
        return 9.87654321;
    }

    public float getTestFloatPrimitive() {
        return 3.14f;
    }

    public Float getTestFloat() {
        return Float.valueOf(6.28f);
    }

    public short getTestShortPrimitive() {
        return 12;
    }

    public Short getTestShort() {
        return (short)21;
    }

    public char getTestCharPrimitive() {
        return 'a';
    }

    public Character getTestChar() {
        return Character.valueOf('z');
    }

    public byte getTestBytePrimitive() {
        return 1;
    }

    public Byte getTestByte() {
        return (byte)2;
    }

    public void testOperationNoParams() {
        System.out.println("JMX operation testOperationNoParams has been invoked.");
    }

    public String testOperationPrimitive(String s, int i, boolean b, long l, double d, float f, short h, char c, byte y) {
        System.out.println("JMX operation testOperationPrimitive has been invoked.");
        return String.format("string=%s, int=%s, boolean=%s, long=%s, double=%s, float=%s, short=%s, char=%s, byte=%s", s, String.valueOf(i), String.valueOf(b), String.valueOf(l), String.valueOf(d), String.valueOf(f), String.valueOf(h), String.valueOf(c), String.valueOf(y));
    }

    public String testOperation(String s, Integer i, Boolean b, Long l, Double d, Float f, Short h, Character c, Byte y) {
        System.out.println("JMX operation testOperation has been invoked.");
        return String.format("String=%s, Int=%s, Boolean=%s, Long=%s, Double=%s, Float=%s, Short=%s, Char=%s, Byte=%s", s, i == null ? "null" : i.toString(), b == null ? "null" : b.toString(), l == null ? "null" : l.toString(), d == null ? "null" : d.toString(), f == null ? "null" : f.toString(), h == null ? "null" : h.toString(), c == null ? "null" : c.toString(), y == null ? "null" : y.toString());
    }
}

