/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson.jsonpointer;

import com.github.fge.jackson.jsonpointer.JsonPointerException;
import com.github.fge.jackson.jsonpointer.JsonPointerMessages;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.ImmutableList;
import java.nio.CharBuffer;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ReferenceToken {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPointerMessages.class);
    private static final char ESCAPE = '~';
    private static final List<Character> ENCODED = ImmutableList.of((Object)Character.valueOf('0'), (Object)Character.valueOf('1'));
    private static final List<Character> DECODED = ImmutableList.of((Object)Character.valueOf('~'), (Object)Character.valueOf('/'));
    private final String cooked;
    private final String raw;

    private ReferenceToken(String cooked, String raw) {
        this.cooked = cooked;
        this.raw = raw;
    }

    public static ReferenceToken fromCooked(String cooked) throws JsonPointerException {
        BUNDLE.checkNotNull(cooked, "nullInput");
        return new ReferenceToken(cooked, ReferenceToken.asRaw(cooked));
    }

    public static ReferenceToken fromRaw(String raw) {
        BUNDLE.checkNotNull(raw, "nullInput");
        return new ReferenceToken(ReferenceToken.asCooked(raw), raw);
    }

    public static ReferenceToken fromInt(int index) {
        String s = Integer.toString(index);
        return new ReferenceToken(s, s);
    }

    public String getRaw() {
        return this.raw;
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceToken other = (ReferenceToken)obj;
        return this.raw.equals(other.raw);
    }

    public String toString() {
        return this.cooked;
    }

    private static String asRaw(String cooked) throws JsonPointerException {
        StringBuilder raw = new StringBuilder(cooked.length());
        CharBuffer buffer = CharBuffer.wrap(cooked);
        boolean inEscape = false;
        while (buffer.hasRemaining()) {
            char c = buffer.get();
            if (inEscape) {
                ReferenceToken.appendEscaped(raw, c);
                inEscape = false;
                continue;
            }
            if (c == '~') {
                inEscape = true;
                continue;
            }
            raw.append(c);
        }
        if (inEscape) {
            throw new JsonPointerException(BUNDLE.getMessage("emptyEscape"));
        }
        return raw.toString();
    }

    private static void appendEscaped(StringBuilder sb, char c) throws JsonPointerException {
        int index = ENCODED.indexOf(Character.valueOf(c));
        if (index == -1) {
            throw new JsonPointerException(BUNDLE.getMessage("illegalEscape"));
        }
        sb.append(DECODED.get(index));
    }

    private static String asCooked(String raw) {
        StringBuilder cooked = new StringBuilder(raw.length());
        CharBuffer buffer = CharBuffer.wrap(raw);
        while (buffer.hasRemaining()) {
            char c = buffer.get();
            int index = DECODED.indexOf(Character.valueOf(c));
            if (index != -1) {
                cooked.append('~').append(ENCODED.get(index));
                continue;
            }
            cooked.append(c);
        }
        return cooked.toString();
    }
}

