/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;

public final class SchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    public SchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle2, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        int size = this.getNode(tree).size();
        if (size == 0) {
            report.error(this.newMsg(tree, bundle2, "common.array.empty"));
            return;
        }
        for (int index = 0; index < size; ++index) {
            pointers.add(JsonPointer.of(this.keyword, index));
        }
    }
}

