/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RequiredKeywordValidator
extends AbstractKeywordValidator {
    private final Set<String> required;

    public RequiredKeywordValidator(JsonNode digest) {
        super("required");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : digest.get(this.keyword)) {
            builder.add((Object)element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
        LinkedHashSet set = Sets.newLinkedHashSet(this.required);
        set.removeAll(Sets.newHashSet(data.getInstance().getNode().fieldNames()));
        if (!set.isEmpty()) {
            report.error(this.newMsg(data, bundle2, "err.common.object.missingMembers").put("required", this.required).putArgument("missing", RequiredKeywordValidator.toArrayNode(set)));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.required.size() + " properties";
    }
}

