/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;

final class CustomHelpFormatter
implements HelpFormatter {
    private static final List<String> HELP_PREAMBLE = ImmutableList.of((Object)"Syntax:", (Object)"    java -jar jsonschema.jar [options] schema file [file...]", (Object)"    java -jar jsonschema.jar --syntax [options] schema [schema...]", (Object)"", (Object)"Options: ");
    private static final List<String> HELP_POST = ImmutableList.builder().add((Object)"").add((Object)"Exit codes:").add((Object)"    0: validation successful;").add((Object)"    1: exception occurred (appears on stderr)").add((Object)"    2: command line syntax error (missing argument, etc)").add((Object)"  100: one or more file(s) failed validation").add((Object)"  101: one or more schema(s) is/are invalid").add((Object)"").add((Object)"Note: by default, the URI of schemas you use in validation mode").add((Object)"(that is, when you don't use --syntax) is considered to be the").add((Object)"current working directory plus the filename. If your schemas").add((Object)"all have a common URI prefix in a top level \"id\", you can fake").add((Object)"that the current directory is that prefix using --fakeroot.").build();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final Joiner JOINER = Joiner.on((String)LINE_SEPARATOR);
    static final Joiner OPTIONS_JOINER = Joiner.on((String)", ");
    private final List<String> lines = Lists.newArrayList();

    CustomHelpFormatter() {
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options) {
        LinkedHashSet<? extends OptionDescriptor> opts = new LinkedHashSet<OptionDescriptor>(options.values());
        this.lines.addAll(HELP_PREAMBLE);
        int helpIndex = this.lines.size();
        for (OptionDescriptor optionDescriptor : opts) {
            if (optionDescriptor.representsNonOptions()) continue;
            Collection<String> names = optionDescriptor.options();
            StringBuilder sb = new StringBuilder().append("    ").append(CustomHelpFormatter.optionsToString(names));
            if (optionDescriptor.requiresArgument()) {
                sb.append(" uri");
            }
            sb.append(": ").append(optionDescriptor.description());
            if (names.contains("help")) {
                this.lines.add(helpIndex, sb.toString());
                continue;
            }
            this.lines.add(sb.toString());
        }
        this.lines.addAll(HELP_POST);
        return JOINER.join(this.lines) + LINE_SEPARATOR;
    }

    private static String optionsToString(Collection<String> names) {
        ArrayList list = Lists.newArrayList();
        for (String name : names) {
            list.add((name.length() == 1 ? "-" : "--") + name);
        }
        return OPTIONS_JOINER.join((Iterable)list);
    }
}

