/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.values;

import com.github.fge.uritemplate.vars.values.ValueType;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class MapValue
extends VariableValue {
    private final Map<String, String> map;

    private MapValue(Builder builder) {
        super(ValueType.MAP);
        this.map = ImmutableMap.copyOf((Map)builder.map);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static <T> VariableValue copyOf(Map<String, T> map) {
        return MapValue.newBuilder().putAll(map).build();
    }

    @Override
    public Map<String, String> getMapValue() {
        return this.map;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @NotThreadSafe
    public static final class Builder {
        private final Map<String, String> map = Maps.newLinkedHashMap();

        private Builder() {
        }

        public <T> Builder put(String key, T value) {
            this.map.put(VariableValue.BUNDLE.checkNotNull(key, "mapValue.nullKey"), VariableValue.BUNDLE.checkNotNull(value, "mapValue.nullValue").toString());
            return this;
        }

        public <T> Builder putAll(Map<String, T> map) {
            VariableValue.BUNDLE.checkNotNull(map, "mapValue.nullMap");
            for (Map.Entry<String, T> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public VariableValue build() {
            return new MapValue(this);
        }
    }
}

