/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.Configuration;
import org.hawkular.agent.javaagent.config.DMRAvail;
import org.hawkular.agent.javaagent.config.DMRAvailSet;
import org.hawkular.agent.javaagent.config.DMRMetric;
import org.hawkular.agent.javaagent.config.DMRMetricSet;
import org.hawkular.agent.javaagent.config.DMROperation;
import org.hawkular.agent.javaagent.config.DMROperationParam;
import org.hawkular.agent.javaagent.config.DMRResourceConfig;
import org.hawkular.agent.javaagent.config.DMRResourceType;
import org.hawkular.agent.javaagent.config.DMRResourceTypeSet;
import org.hawkular.agent.javaagent.config.JMXAvail;
import org.hawkular.agent.javaagent.config.JMXAvailSet;
import org.hawkular.agent.javaagent.config.JMXMetric;
import org.hawkular.agent.javaagent.config.JMXMetricSet;
import org.hawkular.agent.javaagent.config.JMXOperation;
import org.hawkular.agent.javaagent.config.JMXOperationParam;
import org.hawkular.agent.javaagent.config.JMXResourceConfig;
import org.hawkular.agent.javaagent.config.JMXResourceType;
import org.hawkular.agent.javaagent.config.JMXResourceTypeSet;
import org.hawkular.agent.javaagent.config.RemoteDMR;
import org.hawkular.agent.javaagent.config.RemoteJMX;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Interval;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.NodeLocationProvider;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.inventory.TypeSets;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.Constants;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.MeasurementUnit;

public class ConfigConverter {
    private final Configuration sourceConfig;

    public ConfigConverter(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.sourceConfig = config;
    }

    public AgentCoreEngineConfiguration convert() throws Exception {
        Configuration config = this.sourceConfig;
        config.validate();
        AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration = new AgentCoreEngineConfiguration.GlobalConfiguration(config.subsystem.enabled, config.subsystem.immutable, config.subsystem.inContainer, null, config.subsystem.autoDiscoveryScanPeriodSecs, config.subsystem.minCollectionIntervalSecs, 2, config.subsystem.metricDispatcherBufferSize, config.subsystem.metricDispatcherMaxBatchSize, config.subsystem.availDispatcherBufferSize, config.subsystem.availDispatcherMaxBatchSize, config.subsystem.pingPeriodSecs);
        AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnostics = new AgentCoreEngineConfiguration.DiagnosticsConfiguration(config.diagnostics.enabled, AgentCoreEngineConfiguration.DiagnosticsReportTo.valueOf(config.diagnostics.reportTo.name()), config.diagnostics.interval, config.diagnostics.timeUnits.toJavaTimeUnit());
        AgentCoreEngineConfiguration.StorageAdapterConfiguration storageAdapter = new AgentCoreEngineConfiguration.StorageAdapterConfiguration(AgentCoreEngineConfiguration.StorageReportTo.valueOf(config.storageAdapter.type.name()), config.storageAdapter.username, config.storageAdapter.password, config.storageAdapter.tenantId, config.storageAdapter.feedId, config.storageAdapter.url, config.storageAdapter.useSSL(), null, config.storageAdapter.inventoryContext, config.storageAdapter.metricsContext, config.storageAdapter.feedcommContext, null, null, config.storageAdapter.securityRealmName, config.storageAdapter.connectTimeoutSecs, config.storageAdapter.readTimeoutSecs);
        AgentCoreEngineConfiguration.ProtocolConfiguration<DMRNodeLocation> dmrConfiguration = this.buildDmrConfiguration(config);
        AgentCoreEngineConfiguration.ProtocolConfiguration<JMXNodeLocation> jmxConfiguration = this.buildJmxConfiguration(config);
        AgentCoreEngineConfiguration.ProtocolConfiguration<PlatformNodeLocation> platformConfiguration = this.buildPlatformConfiguration(config);
        AgentCoreEngineConfiguration agentConfig = new AgentCoreEngineConfiguration(globalConfiguration, diagnostics, storageAdapter, dmrConfiguration, jmxConfiguration, platformConfiguration);
        return agentConfig;
    }

    /*
     * WARNING - void declaration
     */
    private AgentCoreEngineConfiguration.ProtocolConfiguration<DMRNodeLocation> buildDmrConfiguration(Configuration config) throws Exception {
        MeasurementType type;
        AttributeLocation<DMRNodeLocation> aLocation;
        DMRNodeLocation location;
        TypeSet.TypeSetBuilder<NamedObject> typeSet;
        TypeSets.Builder typeSets = new TypeSets.Builder();
        for (DMRMetricSet dMRMetricSet : config.dmrMetricSets) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(dMRMetricSet.name));
            typeSet.enabled(dMRMetricSet.enabled);
            for (DMRMetric dMRMetric : dMRMetricSet.dmrMetrics) {
                location = new DMRNodeLocation(this.getDmrPathAddress(dMRMetric.path), dMRMetric.resolveExpressions, dMRMetric.includeDefaults);
                aLocation = new AttributeLocation<DMRNodeLocation>(location, dMRMetric.attribute);
                type = new MetricType<DMRNodeLocation>(new ID(dMRMetricSet.name + "~" + dMRMetric.name), new Name(dMRMetric.name), aLocation, new Interval(dMRMetric.interval, dMRMetric.timeUnits.toJavaTimeUnit()), dMRMetric.metricUnits, dMRMetric.metricType, dMRMetric.metricIdTemplate, dMRMetric.metricTags);
                typeSet.type(type);
            }
            typeSets.metricTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.dmrAvailSets) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((DMRAvailSet)validatable).name));
            typeSet.enabled(((DMRAvailSet)validatable).enabled);
            for (Validatable validatable2 : ((DMRAvailSet)validatable).dmrAvails) {
                location = new DMRNodeLocation(this.getDmrPathAddress(((DMRAvail)validatable2).path), ((DMRAvail)validatable2).resolveExpressions, ((DMRAvail)validatable2).includeDefaults);
                aLocation = new AttributeLocation<DMRNodeLocation>(location, ((DMRAvail)validatable2).attribute);
                type = new AvailType<DMRNodeLocation>(new ID(((DMRAvailSet)validatable).name + "~" + ((DMRAvail)validatable2).name), new Name(((DMRAvail)validatable2).name), aLocation, new Interval(((DMRAvail)validatable2).interval, ((DMRAvail)validatable2).timeUnits.toJavaTimeUnit()), Pattern.compile(((DMRAvail)validatable2).upRegex), ((DMRAvail)validatable2).metricIdTemplate, ((DMRAvail)validatable2).metricTags);
                typeSet.type(type);
            }
            typeSets.availTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.dmrResourceTypeSets) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((DMRResourceTypeSet)validatable).name));
            typeSet.enabled(((DMRResourceTypeSet)validatable).enabled);
            for (Validatable validatable3 : ((DMRResourceTypeSet)validatable).dmrResourceTypes) {
                ResourceType.Builder<ResourceType.Builder<?, DMRNodeLocation>, DMRNodeLocation> rtBuilder = ResourceType.builder();
                rtBuilder.name(new Name(((DMRResourceType)validatable3).name));
                rtBuilder.location(DMRNodeLocation.of(((DMRResourceType)validatable3).path));
                rtBuilder.resourceNameTemplate(((DMRResourceType)validatable3).resourceNameTemplate);
                if (((DMRResourceType)validatable3).parents != null) {
                    for (String parent : ((DMRResourceType)validatable3).parents) {
                        rtBuilder.parent(new Name(parent));
                    }
                }
                if (((DMRResourceType)validatable3).metricSets != null) {
                    for (String metricSet : ((DMRResourceType)validatable3).metricSets) {
                        rtBuilder.metricSetName(new Name(metricSet));
                    }
                }
                if (((DMRResourceType)validatable3).availSets != null) {
                    for (String availSet : ((DMRResourceType)validatable3).availSets) {
                        rtBuilder.availSetName(new Name(availSet));
                    }
                }
                if (((DMRResourceType)validatable3).dmrResourceConfigs != null) {
                    for (DMRResourceConfig resConfig : ((DMRResourceType)validatable3).dmrResourceConfigs) {
                        DMRNodeLocation location2 = new DMRNodeLocation(this.getDmrPathAddress(resConfig.path), resConfig.resolveExpressions, resConfig.includeDefaults);
                        AttributeLocation<DMRNodeLocation> aLocation2 = new AttributeLocation<DMRNodeLocation>(location2, resConfig.attribute);
                        rtBuilder.resourceConfigurationPropertyType(new ResourceConfigurationPropertyType<DMRNodeLocation>(ID.NULL_ID, new Name(resConfig.name), aLocation2));
                    }
                }
                if (((DMRResourceType)validatable3).dmrOperations != null) {
                    for (DMROperation dmrOp : ((DMRResourceType)validatable3).dmrOperations) {
                        PathAddress path = this.getDmrPathAddress(dmrOp.path);
                        ArrayList<OperationParam> params = new ArrayList<OperationParam>();
                        if (dmrOp.dmrOperationParams != null) {
                            for (DMROperationParam dmrParam : dmrOp.dmrOperationParams) {
                                OperationParam param = new OperationParam(dmrParam.name, dmrParam.type, dmrParam.description, dmrParam.defaultValue, dmrParam.required);
                                params.add(param);
                            }
                        }
                        Operation<DMRNodeLocation> op = new Operation<DMRNodeLocation>(ID.NULL_ID, new Name(dmrOp.name), new DMRNodeLocation(path), dmrOp.internalName, dmrOp.modifies, params);
                        rtBuilder.operation(op);
                    }
                }
                ConfigConverter.populateMetricAndAvailTypesForResourceType(rtBuilder, typeSets);
                typeSet.type(rtBuilder.build());
            }
            typeSets.resourceTypeSet(typeSet.build());
        }
        HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
        if (config.managedServers.localDmr != null) {
            ConnectionData connectionData = null;
            connectionData = new ConnectionData("http-remoting", "127.0.0.1", 9990, null, null);
            AgentCoreEngineConfiguration.EndpointConfiguration localDmrEndpointConfig = new AgentCoreEngineConfiguration.EndpointConfiguration(config.managedServers.localDmr.name, config.managedServers.localDmr.enabled, this.getNamesFromStrings(config.managedServers.localDmr.resourceTypeSets), connectionData, null, config.managedServers.localDmr.setAvailOnShutdown, config.managedServers.localDmr.tenantId, config.managedServers.localDmr.metricIdTemplate, config.managedServers.localDmr.metricTags, null);
            managedServers.put(config.managedServers.localDmr.name, localDmrEndpointConfig);
        }
        if (config.managedServers.remoteDmrs != null) {
            void var6_16;
            RemoteDMR[] remoteDMRArray = config.managedServers.remoteDmrs;
            int n = remoteDMRArray.length;
            boolean bl = false;
            while (var6_16 < n) {
                RemoteDMR remoteDmr = remoteDMRArray[var6_16];
                if (remoteDmr.protocol == null) {
                    remoteDmr.protocol = remoteDmr.useSsl != false ? "https-remoting" : "http-remoting";
                }
                ConnectionData connectionData = new ConnectionData(remoteDmr.protocol, remoteDmr.host, remoteDmr.port, remoteDmr.username, remoteDmr.password);
                AgentCoreEngineConfiguration.EndpointConfiguration remoteDmrEndpointConfig = new AgentCoreEngineConfiguration.EndpointConfiguration(remoteDmr.name, remoteDmr.enabled, this.getNamesFromStrings(remoteDmr.resourceTypeSets), connectionData, remoteDmr.securityRealmName, remoteDmr.setAvailOnShutdown, remoteDmr.tenantId, remoteDmr.metricIdTemplate, remoteDmr.metricTags, null);
                managedServers.put(remoteDmr.name, remoteDmrEndpointConfig);
                ++var6_16;
            }
        }
        return new AgentCoreEngineConfiguration.ProtocolConfiguration<DMRNodeLocation>(typeSets.build(), managedServers);
    }

    /*
     * WARNING - void declaration
     */
    private AgentCoreEngineConfiguration.ProtocolConfiguration<JMXNodeLocation> buildJmxConfiguration(Configuration config) throws Exception {
        MeasurementType type;
        AttributeLocation<JMXNodeLocation> aLocation;
        JMXNodeLocation location;
        TypeSet.TypeSetBuilder<NamedObject> typeSet;
        TypeSets.Builder typeSets = new TypeSets.Builder();
        for (JMXMetricSet jMXMetricSet : config.jmxMetricSets) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(jMXMetricSet.name));
            typeSet.enabled(jMXMetricSet.enabled);
            for (JMXMetric jMXMetric : jMXMetricSet.jmxMetrics) {
                location = new JMXNodeLocation(this.getJmxObjectName(jMXMetric.objectName));
                aLocation = new AttributeLocation<JMXNodeLocation>(location, jMXMetric.attribute);
                type = new MetricType<JMXNodeLocation>(new ID(jMXMetricSet.name + "~" + jMXMetric.name), new Name(jMXMetric.name), aLocation, new Interval(jMXMetric.interval, jMXMetric.timeUnits.toJavaTimeUnit()), jMXMetric.metricUnits, jMXMetric.metricType, jMXMetric.metricIdTemplate, jMXMetric.metricTags);
                typeSet.type(type);
            }
            typeSets.metricTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.jmxAvailSets) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((JMXAvailSet)validatable).name));
            typeSet.enabled(((JMXAvailSet)validatable).enabled);
            for (Validatable validatable2 : ((JMXAvailSet)validatable).jmxAvails) {
                location = new JMXNodeLocation(this.getJmxObjectName(((JMXAvail)validatable2).objectName));
                aLocation = new AttributeLocation<JMXNodeLocation>(location, ((JMXAvail)validatable2).attribute);
                type = new AvailType<JMXNodeLocation>(new ID(((JMXAvailSet)validatable).name + "~" + ((JMXAvail)validatable2).name), new Name(((JMXAvail)validatable2).name), aLocation, new Interval(((JMXAvail)validatable2).interval, ((JMXAvail)validatable2).timeUnits.toJavaTimeUnit()), Pattern.compile(((JMXAvail)validatable2).upRegex), ((JMXAvail)validatable2).metricIdTemplate, ((JMXAvail)validatable2).metricTags);
                typeSet.type(type);
            }
            typeSets.availTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.jmxResourceTypeSets) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((JMXResourceTypeSet)validatable).name));
            typeSet.enabled(((JMXResourceTypeSet)validatable).enabled);
            for (Validatable validatable3 : ((JMXResourceTypeSet)validatable).jmxResourceTypes) {
                ResourceType.Builder<ResourceType.Builder<?, JMXNodeLocation>, JMXNodeLocation> rtBuilder = ResourceType.builder();
                rtBuilder.name(new Name(((JMXResourceType)validatable3).name));
                rtBuilder.location(new JMXNodeLocation(this.getJmxObjectName(((JMXResourceType)validatable3).objectName)));
                rtBuilder.resourceNameTemplate(((JMXResourceType)validatable3).resourceNameTemplate);
                if (((JMXResourceType)validatable3).parents != null) {
                    for (String parent : ((JMXResourceType)validatable3).parents) {
                        rtBuilder.parent(new Name(parent));
                    }
                }
                if (((JMXResourceType)validatable3).metricSets != null) {
                    for (String metricSet : ((JMXResourceType)validatable3).metricSets) {
                        rtBuilder.metricSetName(new Name(metricSet));
                    }
                }
                if (((JMXResourceType)validatable3).availSets != null) {
                    for (String availSet : ((JMXResourceType)validatable3).availSets) {
                        rtBuilder.availSetName(new Name(availSet));
                    }
                }
                if (((JMXResourceType)validatable3).jmxResourceConfigs != null) {
                    for (JMXResourceConfig resConfig : ((JMXResourceType)validatable3).jmxResourceConfigs) {
                        JMXNodeLocation location2 = new JMXNodeLocation(this.getJmxObjectName(resConfig.objectName));
                        AttributeLocation<JMXNodeLocation> attributeLocation = new AttributeLocation<JMXNodeLocation>(location2, resConfig.attribute);
                        rtBuilder.resourceConfigurationPropertyType(new ResourceConfigurationPropertyType<JMXNodeLocation>(ID.NULL_ID, new Name(resConfig.name), attributeLocation));
                    }
                }
                if (((JMXResourceType)validatable3).jmxOperations != null) {
                    for (JMXOperation jmxOp : ((JMXResourceType)validatable3).jmxOperations) {
                        ArrayList<OperationParam> params = new ArrayList<OperationParam>();
                        if (jmxOp.jmxOperationParams != null) {
                            for (JMXOperationParam jmxParam : jmxOp.jmxOperationParams) {
                                OperationParam param = new OperationParam(jmxParam.name, jmxParam.type, jmxParam.description, jmxParam.defaultValue, jmxParam.required);
                                params.add(param);
                            }
                        }
                        Operation<JMXNodeLocation> operation = new Operation<JMXNodeLocation>(ID.NULL_ID, new Name(jmxOp.name), new JMXNodeLocation(jmxOp.objectName), jmxOp.internalName, jmxOp.modifies, params);
                        rtBuilder.operation(operation);
                    }
                }
                ConfigConverter.populateMetricAndAvailTypesForResourceType(rtBuilder, typeSets);
                typeSet.type(rtBuilder.build());
            }
            typeSets.resourceTypeSet(typeSet.build());
        }
        HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
        if (config.managedServers.localJmx != null) {
            AgentCoreEngineConfiguration.EndpointConfiguration localJmx = new AgentCoreEngineConfiguration.EndpointConfiguration(config.managedServers.localJmx.name, config.managedServers.localJmx.enabled, this.getNamesFromStrings(config.managedServers.localJmx.resourceTypeSets), null, null, config.managedServers.localJmx.setAvailOnShutdown, config.managedServers.localJmx.tenantId, config.managedServers.localJmx.metricIdTemplate, config.managedServers.localJmx.metricTags, Collections.singletonMap("mbean-server-name", config.managedServers.localJmx.mbeanServerName));
            managedServers.put(config.managedServers.localJmx.name, localJmx);
        }
        if (config.managedServers.remoteJmxs != null) {
            void var6_14;
            RemoteJMX[] remoteJMXArray = config.managedServers.remoteJmxs;
            int n = remoteJMXArray.length;
            boolean bl = false;
            while (var6_14 < n) {
                URI url;
                RemoteJMX remoteJmx = remoteJMXArray[var6_14];
                try {
                    url = new URI(remoteJmx.url);
                }
                catch (Exception e) {
                    throw new Exception("Remote JMX [" + remoteJmx.name + "] has invalid URL", e);
                }
                ConnectionData connectionData = new ConnectionData(url, remoteJmx.username, remoteJmx.password);
                AgentCoreEngineConfiguration.EndpointConfiguration remoteJmxEndpointConfig = new AgentCoreEngineConfiguration.EndpointConfiguration(remoteJmx.name, remoteJmx.enabled, this.getNamesFromStrings(remoteJmx.resourceTypeSets), connectionData, remoteJmx.securityRealmName, remoteJmx.setAvailOnShutdown, remoteJmx.tenantId, remoteJmx.metricIdTemplate, remoteJmx.metricTags, null);
                managedServers.put(remoteJmx.name, remoteJmxEndpointConfig);
                ++var6_14;
            }
        }
        return new AgentCoreEngineConfiguration.ProtocolConfiguration<JMXNodeLocation>(typeSets.build(), managedServers);
    }

    private AgentCoreEngineConfiguration.ProtocolConfiguration<PlatformNodeLocation> buildPlatformConfiguration(Configuration config) {
        TypeSet typeSet;
        Interval interval;
        if (!config.platform.enabled.booleanValue()) {
            HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
            return new AgentCoreEngineConfiguration.ProtocolConfiguration<PlatformNodeLocation>(TypeSets.empty(), managedServers);
        }
        TypeSets.Builder typeSets = TypeSets.builder();
        ID osId = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeId();
        Name osName = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName();
        Object rootTypeBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(osId)).name(osName)).location(new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.OPERATING_SYSTEM).build()))).resourceNameTemplate("%s");
        ResourceConfigurationPropertyType<PlatformNodeLocation> machineIdConfigType = new ResourceConfigurationPropertyType<PlatformNodeLocation>(ID.NULL_ID, new Name("Machine Id"), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), "Machine Id"));
        ((ResourceType.Builder)rootTypeBldr).resourceConfigurationPropertyType(machineIdConfigType);
        Interval osInterval = new Interval(config.platform.interval, config.platform.timeUnits.toJavaTimeUnit());
        MetricType<PlatformNodeLocation> systemCpuLoad = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType<PlatformNodeLocation> systemLoadAverage = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType<PlatformNodeLocation> processCount = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId(), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        TypeSet osMetrics = TypeSet.builder().name(Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName()).type(systemCpuLoad).type(systemLoadAverage).type(processCount).build();
        typeSets.metricTypeSet(osMetrics);
        ((ResourceType.Builder)rootTypeBldr).metricSetName(osMetrics.getName());
        ConfigConverter.populateMetricAndAvailTypesForResourceType(rootTypeBldr, typeSets);
        ResourceType rootType = ((ResourceType.Builder)rootTypeBldr).build();
        TypeSet rootTypeSet = TypeSet.builder().enabled(true).name(osName).type(rootType).build();
        typeSets.resourceTypeSet(rootTypeSet);
        if (config.platform.fileStores != null && config.platform.fileStores.enabled.booleanValue()) {
            interval = new Interval(config.platform.fileStores.interval, config.platform.fileStores.timeUnits.toJavaTimeUnit());
            MetricType<PlatformNodeLocation> usableSpace = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            MetricType<PlatformNodeLocation> totalSpace = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet fileStoreMetrics = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type(usableSpace).type(totalSpace).build();
            typeSets.metricTypeSet(fileStoreMetrics);
            PlatformNodeLocation fileStoreLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.FILE_STORE).build());
            Object fileStoreBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.FILE_STORE.getResourceTypeId())).name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName())).location(fileStoreLocation)).resourceNameTemplate(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName().getNameString() + " [%s]")).parent(rootType.getName())).metricSetName(fileStoreMetrics.getName());
            ConfigConverter.populateMetricAndAvailTypesForResourceType(fileStoreBldr, typeSets);
            ResourceType fileStore = ((ResourceType.Builder)fileStoreBldr).build();
            typeSet = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type(fileStore).build();
            typeSets.resourceTypeSet(typeSet);
        }
        if (config.platform.memory != null && config.platform.memory.enabled.booleanValue()) {
            interval = new Interval(config.platform.memory.interval, config.platform.memory.timeUnits.toJavaTimeUnit());
            MetricType<PlatformNodeLocation> available = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            MetricType<PlatformNodeLocation> total = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet memoryMetrics = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type(available).type(total).build();
            typeSets.metricTypeSet(memoryMetrics);
            PlatformNodeLocation memoryLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.MEMORY).build());
            Object memoryBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.MEMORY.getResourceTypeId())).name(Constants.PlatformResourceType.MEMORY.getResourceTypeName())).parent(rootType.getName())).location((PlatformNodeLocation)memoryLocation)).metricSetName(memoryMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.MEMORY.getResourceTypeName().getNameString());
            ConfigConverter.populateMetricAndAvailTypesForResourceType(memoryBldr, typeSets);
            ResourceType memory = ((ResourceType.Builder)memoryBldr).build();
            typeSet = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type(memory).build();
            typeSets.resourceTypeSet(typeSet);
        }
        if (config.platform.processors != null && config.platform.processors.enabled.booleanValue()) {
            interval = new Interval(config.platform.processors.interval, config.platform.processors.timeUnits.toJavaTimeUnit());
            MetricType<PlatformNodeLocation> cpuUsage = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId(), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet processorMetrics = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type(cpuUsage).build();
            typeSets.metricTypeSet(processorMetrics);
            PlatformNodeLocation processorsLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.PROCESSOR).build());
            Object processorBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.PROCESSOR.getResourceTypeId())).name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName())).parent(rootType.getName())).location((PlatformNodeLocation)processorsLocation)).metricSetName(processorMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName().getNameString() + " [%s]");
            ConfigConverter.populateMetricAndAvailTypesForResourceType(processorBldr, typeSets);
            ResourceType processor = ((ResourceType.Builder)processorBldr).build();
            TypeSet typeSet2 = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type(processor).build();
            typeSets.resourceTypeSet(typeSet2);
        }
        if (config.platform.powerSources != null && config.platform.powerSources.enabled.booleanValue()) {
            interval = new Interval(config.platform.powerSources.interval, config.platform.powerSources.timeUnits.toJavaTimeUnit());
            MetricType<PlatformNodeLocation> remainingCap = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            MetricType<PlatformNodeLocation> timeRemaining = new MetricType<PlatformNodeLocation>(Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeName(), new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId().getIDString()), interval, MeasurementUnit.SECONDS, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet powerSourceMetrics = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type(remainingCap).type(timeRemaining).build();
            typeSets.metricTypeSet(powerSourceMetrics);
            PlatformNodeLocation powerSourcesLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.POWER_SOURCE).build());
            Object powerSourceBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeId())).name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName())).parent(rootType.getName())).location((PlatformNodeLocation)powerSourcesLocation)).metricSetName(powerSourceMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName().getNameString() + " [%s]");
            ConfigConverter.populateMetricAndAvailTypesForResourceType(powerSourceBldr, typeSets);
            ResourceType powerSource = ((ResourceType.Builder)powerSourceBldr).build();
            typeSet = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type(powerSource).build();
            typeSets.resourceTypeSet(typeSet);
        }
        HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
        if (config.platform.enabled.booleanValue()) {
            AgentCoreEngineConfiguration.EndpointConfiguration localPlatform = new AgentCoreEngineConfiguration.EndpointConfiguration("platform", true, null, null, null, Avail.DOWN, null, null, null, Collections.singletonMap("Machine Id", config.platform.machineId));
            managedServers.put("platform", localPlatform);
        }
        return new AgentCoreEngineConfiguration.ProtocolConfiguration<PlatformNodeLocation>(typeSets.build(), managedServers);
    }

    private static <L> void populateMetricAndAvailTypesForResourceType(ResourceType.Builder<?, L> resourceTypeBuilder, TypeSets.Builder<L> typeSetsBuilder) {
        Map<Name, TypeSet<MetricType<L>>> metricTypeSets = typeSetsBuilder.getMetricTypeSets();
        List<Name> metricSetNames = resourceTypeBuilder.getMetricSetNames();
        for (Name metricSetName : metricSetNames) {
            TypeSet<MetricType<L>> metricSet = metricTypeSets.get(metricSetName);
            if (metricSet == null || !metricSet.isEnabled()) continue;
            resourceTypeBuilder.metricTypes(metricSet.getTypeMap().values());
        }
        Map<Name, TypeSet<AvailType<L>>> availTypeSets = typeSetsBuilder.getAvailTypeSets();
        List<Name> availSetNames = resourceTypeBuilder.getAvailSetNames();
        for (Name availSetName : availSetNames) {
            TypeSet<AvailType<L>> availSet = availTypeSets.get(availSetName);
            if (availSet == null || !availSet.isEnabled()) continue;
            resourceTypeBuilder.availTypes(availSet.getTypeMap().values());
        }
    }

    private PathAddress getDmrPathAddress(String path) {
        if (path == null) {
            return PathAddress.EMPTY_ADDRESS;
        }
        if ("/".equals(path)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        return WildflyCompatibilityUtils.parseCLIStyleAddress(path);
    }

    private ObjectName getJmxObjectName(String on) throws Exception {
        if (on == null || on.trim().isEmpty()) {
            return null;
        }
        return new ObjectName(on);
    }

    private Collection<Name> getNamesFromStrings(String[] arr) {
        if (arr == null) {
            return Collections.emptyList();
        }
        ArrayList<Name> names = new ArrayList<Name>();
        for (String s : arr) {
            names.add(new Name(s));
        }
        return names;
    }
}

