/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMRAvailSet;
import org.hawkular.agent.javaagent.config.DMRMetricSet;
import org.hawkular.agent.javaagent.config.DMRResourceTypeSet;
import org.hawkular.agent.javaagent.config.Diagnostics;
import org.hawkular.agent.javaagent.config.JMXAvailSet;
import org.hawkular.agent.javaagent.config.JMXMetricSet;
import org.hawkular.agent.javaagent.config.JMXResourceTypeSet;
import org.hawkular.agent.javaagent.config.ManagedServers;
import org.hawkular.agent.javaagent.config.Platform;
import org.hawkular.agent.javaagent.config.SecurityRealm;
import org.hawkular.agent.javaagent.config.StorageAdapter;
import org.hawkular.agent.javaagent.config.Subsystem;
import org.hawkular.agent.javaagent.config.Validatable;

public class Configuration
implements Validatable {
    @JsonProperty
    public Subsystem subsystem;
    @JsonProperty(value="security-realm")
    public SecurityRealm[] securityRealms;
    @JsonProperty(value="storage-adapter")
    public StorageAdapter storageAdapter = new StorageAdapter();
    @JsonProperty
    public Diagnostics diagnostics = new Diagnostics();
    @JsonProperty(value="metric-set-dmr")
    public DMRMetricSet[] dmrMetricSets;
    @JsonProperty(value="avail-set-dmr")
    public DMRAvailSet[] dmrAvailSets;
    @JsonProperty(value="resource-type-set-dmr")
    public DMRResourceTypeSet[] dmrResourceTypeSets;
    @JsonProperty(value="metric-set-jmx")
    public JMXMetricSet[] jmxMetricSets;
    @JsonProperty(value="avail-set-jmx")
    public JMXAvailSet[] jmxAvailSets;
    @JsonProperty(value="resource-type-set-jmx")
    public JMXResourceTypeSet[] jmxResourceTypeSets;
    @JsonProperty(value="managed-servers")
    public ManagedServers managedServers = new ManagedServers();
    @JsonProperty
    public Platform platform = new Platform();

    public Configuration() {
    }

    public Configuration(Configuration original) {
        this.subsystem = new Subsystem(original.subsystem);
        this.securityRealms = Util.cloneArray(original.securityRealms);
        this.storageAdapter = new StorageAdapter(original.storageAdapter);
        this.diagnostics = new Diagnostics(original.diagnostics);
        this.dmrMetricSets = Util.cloneArray(original.dmrMetricSets);
        this.dmrAvailSets = Util.cloneArray(original.dmrAvailSets);
        this.dmrResourceTypeSets = Util.cloneArray(original.dmrResourceTypeSets);
        this.jmxMetricSets = Util.cloneArray(original.jmxMetricSets);
        this.jmxAvailSets = Util.cloneArray(original.jmxAvailSets);
        this.jmxResourceTypeSets = Util.cloneArray(original.jmxResourceTypeSets);
        this.managedServers = new ManagedServers(original.managedServers);
        this.platform = new Platform(original.platform);
    }

    @Override
    public void validate() throws Exception {
        if (this.subsystem == null) {
            throw new Exception("subsystem must be specified");
        }
        if (this.securityRealms == null) {
            this.securityRealms = new SecurityRealm[0];
        }
        if (this.dmrMetricSets == null) {
            this.dmrMetricSets = new DMRMetricSet[0];
        }
        if (this.dmrAvailSets == null) {
            this.dmrAvailSets = new DMRAvailSet[0];
        }
        if (this.dmrResourceTypeSets == null) {
            this.dmrResourceTypeSets = new DMRResourceTypeSet[0];
        }
        if (this.jmxMetricSets == null) {
            this.jmxMetricSets = new JMXMetricSet[0];
        }
        if (this.jmxAvailSets == null) {
            this.jmxAvailSets = new JMXAvailSet[0];
        }
        if (this.jmxResourceTypeSets == null) {
            this.jmxResourceTypeSets = new JMXResourceTypeSet[0];
        }
        this.subsystem.validate();
        this.storageAdapter.validate();
        for (SecurityRealm securityRealm : this.securityRealms) {
            securityRealm.validate();
        }
        this.diagnostics.validate();
        for (Validatable validatable : this.dmrMetricSets) {
            ((DMRMetricSet)validatable).validate();
        }
        for (Validatable validatable : this.dmrAvailSets) {
            ((DMRAvailSet)validatable).validate();
        }
        for (Validatable validatable : this.dmrResourceTypeSets) {
            ((DMRResourceTypeSet)validatable).validate();
        }
        for (Validatable validatable : this.jmxMetricSets) {
            ((JMXMetricSet)validatable).validate();
        }
        for (Validatable validatable : this.jmxAvailSets) {
            ((JMXAvailSet)validatable).validate();
        }
        for (Validatable validatable : this.jmxResourceTypeSets) {
            ((JMXResourceTypeSet)validatable).validate();
        }
        this.managedServers.validate();
        this.platform.validate();
    }
}

