/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

public class DMRAvail
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty
    public String path = "/";
    @JsonProperty
    public String attribute;
    @JsonProperty(value="resolve-expressions")
    public Boolean resolveExpressions = Boolean.FALSE;
    @JsonProperty(value="include-defaults")
    public Boolean includeDefaults = Boolean.TRUE;
    @JsonProperty(value="up-regex")
    public String upRegex;
    @JsonProperty
    public Integer interval = 5;
    @JsonProperty(value="time-units")
    public TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="metric-id-template")
    public String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    public Map<String, String> metricTags;

    public DMRAvail() {
    }

    public DMRAvail(DMRAvail original) {
        this.name = original.name;
        this.path = original.path;
        this.attribute = original.attribute;
        this.resolveExpressions = original.resolveExpressions;
        this.includeDefaults = original.includeDefaults;
        this.upRegex = original.upRegex;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("avail-dmr name must be specified");
        }
        if (this.interval == null || this.interval < 0) {
            throw new Exception("avail-dmr [" + this.name + "] interval must be greater than or equal to 0");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("avail-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
    }
}

