/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.hawkular.metrics.client.common.MetricType;
import org.jboss.as.controller.client.helpers.MeasurementUnit;

public class DMRMetric
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty
    public String path = "/";
    @JsonProperty(required=true)
    public String attribute;
    @JsonProperty(value="resolve-expressions")
    public Boolean resolveExpressions = Boolean.FALSE;
    @JsonProperty(value="include-defaults")
    public Boolean includeDefaults = Boolean.TRUE;
    @JsonProperty
    public Integer interval = 5;
    @JsonProperty(value="time-units")
    public TimeUnits timeUnits = TimeUnits.minutes;
    public MeasurementUnit metricUnits = MeasurementUnit.NONE;
    public MetricType metricType = MetricType.GAUGE;
    @JsonProperty(value="metric-id-template")
    public String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    public Map<String, String> metricTags;

    @JsonProperty(value="metric-units")
    private String getMetricUnits() {
        return this.metricUnits != null ? this.metricUnits.name() : MeasurementUnit.NONE.name();
    }

    private void setMetricUnits(String s) {
        this.metricUnits = s != null ? MeasurementUnit.valueOf(s.toUpperCase(Locale.ENGLISH)) : MeasurementUnit.NONE;
    }

    @JsonProperty(value="metric-type")
    private String getMetricType() {
        return this.metricType != null ? this.metricType.toString() : MetricType.GAUGE.name();
    }

    private void setMetricType(String s) {
        this.metricType = s != null ? MetricType.valueOf(s.toUpperCase(Locale.ENGLISH)) : MetricType.GAUGE;
    }

    public DMRMetric() {
    }

    public DMRMetric(DMRMetric original) {
        this.name = original.name;
        this.path = original.path;
        this.attribute = original.attribute;
        this.resolveExpressions = original.resolveExpressions;
        this.includeDefaults = original.includeDefaults;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.metricUnits = original.metricUnits;
        this.metricType = original.metricType;
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("metric-dmr name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("metric-dmr [" + this.name + "] attribute must be specified");
        }
        if (this.interval == null || this.interval < 0) {
            throw new Exception("metric-dmr [" + this.name + "] interval must be greater than or equal to 0");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("metric-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
    }
}

