/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMROperationParam;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

public class DMROperation
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty
    public String path = "/";
    @JsonProperty(value="internal-name")
    public String internalName;
    @JsonProperty
    public Boolean modifies = Boolean.FALSE;
    @JsonProperty(value="params")
    public DMROperationParam[] dmrOperationParams;

    public DMROperation() {
    }

    public DMROperation(DMROperation original) {
        this.name = original.name;
        this.path = original.path;
        this.internalName = original.internalName;
        this.modifies = original.modifies;
        this.dmrOperationParams = Util.cloneArray(original.dmrOperationParams);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("operation-dmr name must be specified");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("operation-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
        if (this.dmrOperationParams != null) {
            for (DMROperationParam o : this.dmrOperationParams) {
                o.validate();
            }
        }
    }
}

