/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

public class DMRResourceConfig
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty
    public String path = "/";
    @JsonProperty(required=true)
    public String attribute;
    @JsonProperty(value="resolve-expressions")
    public Boolean resolveExpressions = Boolean.FALSE;
    @JsonProperty(value="include-defaults")
    public Boolean includeDefaults = Boolean.TRUE;

    public DMRResourceConfig() {
    }

    public DMRResourceConfig(DMRResourceConfig original) {
        this.name = original.name;
        this.path = original.path;
        this.attribute = original.attribute;
        this.resolveExpressions = original.resolveExpressions;
        this.includeDefaults = original.includeDefaults;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("resource-config-dmr name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("resource-config-dmr [" + this.name + "] attribute must be specified");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("resource-config-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
    }
}

