/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMROperation;
import org.hawkular.agent.javaagent.config.DMRResourceConfig;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

public class DMRResourceType
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty
    public String path = "/";
    @JsonProperty(value="resource-name-template", required=true)
    public String resourceNameTemplate;
    @JsonProperty
    public String[] parents;
    @JsonProperty(value="metric-sets")
    public String[] metricSets;
    @JsonProperty(value="avail-sets")
    public String[] availSets;
    @JsonProperty(value="resource-config-dmr")
    public DMRResourceConfig[] dmrResourceConfigs;
    @JsonProperty(value="operation-dmr")
    public DMROperation[] dmrOperations;

    public DMRResourceType() {
    }

    public DMRResourceType(DMRResourceType original) {
        this.name = original.name;
        this.path = original.path;
        this.resourceNameTemplate = original.resourceNameTemplate;
        this.parents = original.parents == null ? null : Arrays.copyOf(original.parents, original.parents.length);
        this.metricSets = original.metricSets == null ? null : Arrays.copyOf(original.metricSets, original.metricSets.length);
        this.availSets = original.availSets == null ? null : Arrays.copyOf(original.availSets, original.availSets.length);
        this.dmrResourceConfigs = Util.cloneArray(original.dmrResourceConfigs);
        this.dmrOperations = Util.cloneArray(original.dmrOperations);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("resource-type-dmr name must be specified");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("resource-type-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
        if (this.dmrResourceConfigs != null) {
            for (Validatable validatable : this.dmrResourceConfigs) {
                ((DMRResourceConfig)validatable).validate();
            }
        }
        if (this.dmrOperations != null) {
            for (Validatable validatable : this.dmrOperations) {
                ((DMROperation)validatable).validate();
            }
        }
    }
}

