/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;

public class JMXAvail
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty(value="object-name")
    public String objectName;
    @JsonProperty(required=true)
    public String attribute;
    @JsonProperty(value="up-regex")
    public String upRegex;
    @JsonProperty
    public Integer interval = 5;
    @JsonProperty(value="time-units")
    public TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="metric-id-template")
    public String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    public Map<String, String> metricTags;

    public JMXAvail() {
    }

    public JMXAvail(JMXAvail original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.attribute = original.attribute;
        this.upRegex = original.upRegex;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("avail-jmx name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("avail-jmx [" + this.name + "] attribute must be specified");
        }
        if (this.interval == null || this.interval < 0) {
            throw new Exception("avail-jmx [" + this.name + "] interval must be greater than or equal to 0");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("avail-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
    }
}

