/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.metrics.client.common.MetricType;
import org.jboss.as.controller.client.helpers.MeasurementUnit;

public class JMXMetric
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty(value="object-name")
    public String objectName;
    @JsonProperty(required=true)
    public String attribute;
    @JsonProperty
    public Integer interval = 5;
    @JsonProperty(value="time-units")
    public TimeUnits timeUnits = TimeUnits.minutes;
    public MeasurementUnit metricUnits = MeasurementUnit.NONE;
    public MetricType metricType = MetricType.GAUGE;
    @JsonProperty(value="metric-id-template")
    public String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    public Map<String, String> metricTags;

    @JsonProperty(value="metric-units")
    private String getMetricUnits() {
        return this.metricUnits != null ? this.metricUnits.name() : MeasurementUnit.NONE.name();
    }

    private void setMetricUnits(String s) {
        this.metricUnits = s != null ? MeasurementUnit.valueOf(s.toUpperCase(Locale.ENGLISH)) : MeasurementUnit.NONE;
    }

    @JsonProperty(value="metric-type")
    private String getMetricType() {
        return this.metricType != null ? this.metricType.toString() : MetricType.GAUGE.name();
    }

    private void setMetricType(String s) {
        this.metricType = s != null ? MetricType.valueOf(s.toUpperCase(Locale.ENGLISH)) : MetricType.GAUGE;
    }

    public JMXMetric() {
    }

    public JMXMetric(JMXMetric original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.attribute = original.attribute;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.metricUnits = original.metricUnits;
        this.metricType = original.metricType;
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("metric-jmx name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("metric-jmx [" + this.name + "] attribute must be specified");
        }
        if (this.interval == null || this.interval < 0) {
            throw new Exception("metric-jmx [" + this.name + "] interval must be greater than or equal to 0");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("metric-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
    }
}

