/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXOperationParam;
import org.hawkular.agent.javaagent.config.Validatable;

public class JMXOperation
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty(value="object-name")
    public String objectName;
    @JsonProperty(value="internal-name")
    public String internalName;
    @JsonProperty
    public Boolean modifies = Boolean.FALSE;
    @JsonProperty(value="params")
    public JMXOperationParam[] jmxOperationParams;

    public JMXOperation() {
    }

    public JMXOperation(JMXOperation original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.internalName = original.internalName;
        this.modifies = original.modifies;
        this.jmxOperationParams = Util.cloneArray(original.jmxOperationParams);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("operation-jmx name must be specified");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("operation-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
        if (this.jmxOperationParams != null) {
            for (JMXOperationParam o : this.jmxOperationParams) {
                o.validate();
            }
        }
    }
}

