/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.Validatable;

public class JMXResourceConfig
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty(value="object-name")
    public String objectName;
    @JsonProperty(required=true)
    public String attribute;

    public JMXResourceConfig() {
    }

    public JMXResourceConfig(JMXResourceConfig original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.attribute = original.attribute;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("resource-config-jmx name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("resource-config-jmx [" + this.name + "] attribute must be specified");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("resource-config-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
    }
}

