/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXOperation;
import org.hawkular.agent.javaagent.config.JMXResourceConfig;
import org.hawkular.agent.javaagent.config.Validatable;

public class JMXResourceType
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty(value="object-name", required=true)
    public String objectName;
    @JsonProperty(value="resource-name-template", required=true)
    public String resourceNameTemplate;
    @JsonProperty
    public String[] parents;
    @JsonProperty(value="metric-sets")
    public String[] metricSets;
    @JsonProperty(value="avail-sets")
    public String[] availSets;
    @JsonProperty(value="resource-config-jmx")
    public JMXResourceConfig[] jmxResourceConfigs;
    @JsonProperty(value="operation-jmx")
    public JMXOperation[] jmxOperations;

    public JMXResourceType() {
    }

    public JMXResourceType(JMXResourceType original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.resourceNameTemplate = original.resourceNameTemplate;
        this.parents = original.parents == null ? null : Arrays.copyOf(original.parents, original.parents.length);
        this.metricSets = original.metricSets == null ? null : Arrays.copyOf(original.metricSets, original.metricSets.length);
        this.availSets = original.availSets == null ? null : Arrays.copyOf(original.availSets, original.availSets.length);
        this.jmxResourceConfigs = Util.cloneArray(original.jmxResourceConfigs);
        this.jmxOperations = Util.cloneArray(original.jmxOperations);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("resource-type-jmx name must be specified");
        }
        if (this.objectName == null) {
            throw new Exception("resource-type-jmx [" + this.name + "] object-name must be specified");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("resource-type-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
        if (this.resourceNameTemplate == null) {
            throw new Exception("resource-type-jmx [" + this.name + "] resource-name-template must be specified");
        }
        if (this.jmxResourceConfigs != null) {
            for (Validatable validatable : this.jmxResourceConfigs) {
                ((JMXResourceConfig)validatable).validate();
            }
        }
        if (this.jmxOperations != null) {
            for (Validatable validatable : this.jmxOperations) {
                ((JMXOperation)validatable).validate();
            }
        }
    }
}

