/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;

public class Platform
implements Validatable {
    @JsonProperty
    public Boolean enabled = Boolean.FALSE;
    @JsonProperty
    public Integer interval = 5;
    @JsonProperty(value="time-units")
    public TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="machine-id")
    public String machineId;
    @JsonProperty(value="file-stores")
    public PlatformChild fileStores = new PlatformChild(true, 5, TimeUnits.minutes);
    @JsonProperty
    public PlatformChild memory = new PlatformChild(true, 5, TimeUnits.minutes);
    @JsonProperty
    public PlatformChild processors = new PlatformChild(true, 5, TimeUnits.minutes);
    @JsonProperty(value="power-sources")
    public PlatformChild powerSources = new PlatformChild(false, 5, TimeUnits.minutes);

    public Platform() {
    }

    public Platform(Platform original) {
        this.enabled = original.enabled;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.machineId = original.machineId;
        this.fileStores = new PlatformChild(original.fileStores);
        this.memory = new PlatformChild(original.memory);
        this.processors = new PlatformChild(original.processors);
        this.powerSources = new PlatformChild(original.powerSources);
    }

    @Override
    public void validate() throws Exception {
        if (this.interval == null || this.interval < 0) {
            throw new Exception("platform intervals must be greater than or equal to 0");
        }
    }

    public static class PlatformChild
    implements Validatable {
        @JsonProperty
        public Boolean enabled = Boolean.TRUE;
        @JsonProperty
        public Integer interval = 5;
        @JsonProperty(value="time-units")
        public TimeUnits timeUnits = TimeUnits.minutes;

        public PlatformChild() {
        }

        public PlatformChild(PlatformChild original) {
            this.enabled = original.enabled;
            this.interval = original.interval;
            this.timeUnits = original.timeUnits;
        }

        public PlatformChild(Boolean e, Integer i, TimeUnits t) {
            this.enabled = e;
            this.interval = i;
            this.timeUnits = t;
        }

        @Override
        public void validate() throws Exception {
            if (this.interval == null || this.interval < 0) {
                throw new Exception("platform intervals must be greater than or equal to 0");
            }
        }
    }
}

