/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.hawkular.agent.javaagent.config.Validatable;

public class SecurityRealm
implements Validatable {
    @JsonProperty(required=true)
    public String name;
    @JsonProperty(value="keystore-path", required=true)
    public String keystorePath;
    @JsonProperty(value="keystore-password", required=true)
    public String keystorePassword;
    @JsonProperty(value="key-password")
    public String keyPassword;
    @JsonProperty(value="keystore-type")
    public String keystoreType = KeyStore.getDefaultType();
    @JsonProperty(value="key-manager-algorithm")
    public String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    @JsonProperty(value="trust-manager-algorithm")
    public String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    @JsonProperty(value="ssl-protocol")
    public String sslProtocol = "TLSv1";

    public SecurityRealm() {
    }

    public SecurityRealm(SecurityRealm original) {
        this.name = original.name;
        this.keystorePath = original.keystorePath;
        this.keystorePassword = original.keystorePassword;
        this.keyPassword = original.keyPassword;
        this.keystoreType = original.keystoreType;
        this.keyManagerAlgorithm = original.keyManagerAlgorithm;
        this.trustManagerAlgorithm = original.trustManagerAlgorithm;
        this.sslProtocol = original.sslProtocol;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("security-realm name must be specified");
        }
        if (this.keystorePath == null || this.keystorePath.trim().length() == 0) {
            throw new Exception("security-realm: [" + this.name + "] keystore-path must be specified");
        }
        if (this.keystorePassword == null || this.keystorePassword.trim().length() == 0) {
            throw new Exception("security-realm: [" + this.name + "] keystore-password must be specified");
        }
        try {
            KeyStore.getInstance(this.keystoreType);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] keystore-type [" + this.keystoreType + "] is invalid. You may want to use the VM default of [" + KeyStore.getDefaultType() + "]", e);
        }
        try {
            KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] key-manager-algorithm [" + this.keyManagerAlgorithm + "] is invalid. You may want to use the VM default of [" + KeyManagerFactory.getDefaultAlgorithm() + "]", e);
        }
        try {
            TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] trust-manager-algorithm [" + this.trustManagerAlgorithm + "] is invalid. You may want to use the VM default of [" + TrustManagerFactory.getDefaultAlgorithm() + "]", e);
        }
        try {
            SSLContext.getInstance(this.sslProtocol);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] ssl-protocol [" + this.sslProtocol + "] is invalid. You may want to use [TLSv1]", e);
        }
    }
}

