/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import org.hawkular.agent.javaagent.config.Validatable;

public class StorageAdapter
implements Validatable {
    @JsonProperty
    public Type type = Type.HAWKULAR;
    @JsonProperty
    public String url = "http://127.0.0.1:8080";
    @JsonProperty(value="tenant-id")
    public String tenantId = "hawkular";
    @JsonProperty
    public String username = "";
    @JsonProperty
    public String password = "";
    @JsonProperty(value="feed-id")
    public String feedId = "autogenerate";
    @JsonProperty(value="security-realm")
    public String securityRealmName;
    @JsonProperty(value="inventory-context")
    public String inventoryContext = "/hawkular/inventory/";
    @JsonProperty(value="metrics-context")
    public String metricsContext = "/hawkular/metrics/";
    @JsonProperty(value="feedcomm-context")
    public String feedcommContext = "/hawkular/command-gateway/";
    @JsonProperty(value="connect-timeout-secs")
    public Integer connectTimeoutSecs = 10;
    @JsonProperty(value="read-timeout-secs")
    public Integer readTimeoutSecs = 120;

    public StorageAdapter() {
    }

    public StorageAdapter(StorageAdapter original) {
        this.type = original.type;
        this.url = original.url;
        this.tenantId = original.tenantId;
        this.username = original.username;
        this.password = original.password;
        this.feedId = original.feedId;
        this.securityRealmName = original.securityRealmName;
        this.inventoryContext = original.inventoryContext;
        this.metricsContext = original.metricsContext;
        this.feedcommContext = original.feedcommContext;
        this.connectTimeoutSecs = original.connectTimeoutSecs;
        this.readTimeoutSecs = original.readTimeoutSecs;
    }

    public boolean useSSL() {
        return this.url != null && this.url.startsWith("https:");
    }

    @Override
    public void validate() throws Exception {
        try {
            new URL(this.url);
        }
        catch (Exception e) {
            throw new Exception("storage-adapter url is invalid", e);
        }
        if (this.connectTimeoutSecs != null && this.connectTimeoutSecs <= 0) {
            throw new Exception("storage-adapter connect-timeout-secs must be greater than or equal to 0");
        }
        if (this.readTimeoutSecs != null && this.readTimeoutSecs <= 0) {
            throw new Exception("storage-adapter read-timeout-secs must be greater than or equal to 0");
        }
    }

    public static enum Type {
        HAWKULAR,
        METRICS;

    }
}

