/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.Validatable;

public class Subsystem
implements Validatable {
    @JsonProperty
    public Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="auto-discovery-scan-period-secs")
    public Integer autoDiscoveryScanPeriodSecs = 600;
    @JsonProperty(value="min-collection-interval-secs")
    public Integer minCollectionIntervalSecs = 30;
    @JsonProperty
    public Boolean immutable = Boolean.FALSE;
    @JsonProperty(value="in-container")
    public Boolean inContainer = Boolean.FALSE;
    @JsonProperty(value="metric-dispatcher-buffer-size")
    public Integer metricDispatcherBufferSize = 1000;
    @JsonProperty(value="metric-dispatcher-max-batch-size")
    public Integer metricDispatcherMaxBatchSize = 100;
    @JsonProperty(value="avail-dispatcher-buffer-size")
    public Integer availDispatcherBufferSize = 500;
    @JsonProperty(value="avail-dispatcher-max-batch-size")
    public Integer availDispatcherMaxBatchSize = 50;
    @JsonProperty(value="ping-period-secs")
    public Integer pingPeriodSecs = 60;

    public Subsystem() {
    }

    public Subsystem(Subsystem subsystem) {
        this.enabled = subsystem.enabled;
        this.autoDiscoveryScanPeriodSecs = subsystem.autoDiscoveryScanPeriodSecs;
        this.minCollectionIntervalSecs = subsystem.minCollectionIntervalSecs;
        this.immutable = subsystem.immutable;
        this.inContainer = subsystem.inContainer;
        this.metricDispatcherBufferSize = subsystem.metricDispatcherBufferSize;
        this.metricDispatcherMaxBatchSize = subsystem.metricDispatcherMaxBatchSize;
        this.availDispatcherBufferSize = subsystem.availDispatcherBufferSize;
        this.availDispatcherMaxBatchSize = subsystem.availDispatcherMaxBatchSize;
        this.pingPeriodSecs = subsystem.pingPeriodSecs;
    }

    @Override
    public void validate() throws Exception {
        if (this.autoDiscoveryScanPeriodSecs != null && this.autoDiscoveryScanPeriodSecs <= 0) {
            throw new Exception("subsystem auto-discovery-scan-period-secs must be greater than 0");
        }
        if (this.minCollectionIntervalSecs != null && this.minCollectionIntervalSecs <= 0) {
            throw new Exception("subsystem min-collection-interval-secs must be greater than 0");
        }
        if (this.metricDispatcherBufferSize != null && this.metricDispatcherBufferSize <= 0) {
            throw new Exception("subsystem metric-dispatcher-buffer-size must be greater than 0");
        }
        if (this.metricDispatcherMaxBatchSize != null && this.metricDispatcherMaxBatchSize <= 0) {
            throw new Exception("subsystem metric-dispatcher-max-batch-size must be greater than 0");
        }
        if (this.availDispatcherBufferSize != null && this.availDispatcherBufferSize <= 0) {
            throw new Exception("subsystem avail-dispatcher-buffer-size must be greater than 0");
        }
        if (this.availDispatcherMaxBatchSize != null && this.availDispatcherMaxBatchSize <= 0) {
            throw new Exception("subsystem avail-dispatcher-max-batch-size must be greater than 0");
        }
        if (this.pingPeriodSecs != null && this.pingPeriodSecs < 0) {
            throw new Exception("subsystem ping-period-secs must be greater than or equal to 0");
        }
    }
}

