/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pAuthenticator;
import org.jolokia.client.J4pClient;

public class JolokiaClientFactory {
    private static final String BEARER_TOKEN_USER_ID = "_bearer";
    private final MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint;

    public JolokiaClientFactory(MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint) {
        this.endpoint = endpoint;
    }

    public J4pClient createClient() {
        J4pAuthenticator authenticator;
        SSLConnectionSocketFactory sslFactory;
        ConnectionData cnData = this.endpoint.getConnectionData();
        SSLContext sslContext = this.endpoint.getSSLContext();
        boolean useBearerAuth = false;
        if (cnData.getUsername() != null && cnData.getUsername().equalsIgnoreCase(BEARER_TOKEN_USER_ID)) {
            if (cnData.getPassword() == null) {
                throw new IllegalStateException("Bearer token is missing. Must be specified as the password");
            }
            useBearerAuth = true;
        }
        if (sslContext != null && cnData.getUri().getScheme().equalsIgnoreCase("https")) {
            sslFactory = new SSLConnectionSocketFactory(sslContext);
            authenticator = useBearerAuth ? new SecureBearerAuthenticator(sslContext) : new SecureBasicAuthenticator(sslContext).preemptive();
        } else {
            sslFactory = null;
            authenticator = useBearerAuth ? new BearerAuthenticator() : new BasicAuthenticator().preemptive();
        }
        J4pClient client = J4pClient.url(cnData.getUri().toString()).user(cnData.getUsername()).password(cnData.getPassword()).authenticator(authenticator).connectionTimeout(60000).sslConnectionSocketFactory(sslFactory).build();
        return client;
    }

    private class BearerAuthenticator
    implements J4pAuthenticator {
        private BearerAuthenticator() {
        }

        @Override
        public void authenticate(HttpClientBuilder pBuilder, String pUser, String pPassword) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY), new UsernamePasswordCredentials(pUser, pPassword));
            pBuilder.setDefaultCredentialsProvider(credentialsProvider);
            pBuilder.addInterceptorFirst(new PreemptiveAuthInterceptor(new BearerScheme()));
        }

        class PreemptiveAuthInterceptor
        implements HttpRequestInterceptor {
            private AuthScheme authScheme;

            PreemptiveAuthInterceptor(AuthScheme pScheme) {
                this.authScheme = pScheme;
            }

            @Override
            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                if (authState.getAuthScheme() == null) {
                    HttpHost targetHost;
                    CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                    Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials given for preemptive authentication");
                    }
                    authState.update(this.authScheme, creds);
                }
            }
        }
    }

    private class BearerScheme
    extends BasicScheme {
        private BearerScheme() {
        }

        @Override
        public String getSchemeName() {
            return "bearer";
        }

        @Override
        public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
            Args.notNull(credentials, "Credentials");
            Args.notNull(request, "HTTP request");
            String bearerToken = credentials.getPassword();
            CharArrayBuffer buffer = new CharArrayBuffer(64);
            if (this.isProxy()) {
                buffer.append("Proxy-Authorization");
            } else {
                buffer.append("Authorization");
            }
            buffer.append(": Bearer ");
            buffer.append(bearerToken);
            return new BufferedHeader(buffer);
        }
    }

    private class SecureBearerAuthenticator
    extends BearerAuthenticator {
        private final SSLContext sslContext;

        public SecureBearerAuthenticator(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        @Override
        public void authenticate(HttpClientBuilder pBuilder, String pUser, String pPassword) {
            pBuilder.setSSLSocketFactory(new SSLConnectionSocketFactory(this.sslContext));
            super.authenticate(pBuilder, pUser, pPassword);
        }
    }

    private static class SecureBasicAuthenticator
    extends BasicAuthenticator {
        private final SSLContext sslContext;

        public SecureBasicAuthenticator(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        @Override
        public void authenticate(HttpClientBuilder pBuilder, String pUser, String pPassword) {
            pBuilder.setSSLSocketFactory(new SSLConnectionSocketFactory(this.sslContext));
            super.authenticate(pBuilder, pUser, pPassword);
        }
    }
}

