/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Resource;

public class ScheduledMeasurementInstance<L, T extends MeasurementType<L>>
implements Comparable<ScheduledMeasurementInstance<L, T>> {
    private final MeasurementInstance<L, T> measurementInstance;
    private final Resource<L> resource;
    private long nextCollectionTime;

    public static <LL> Set<ScheduledMeasurementInstance<LL, MetricType<LL>>> createMetrics(Resource<LL> resource) {
        long now = System.currentTimeMillis();
        HashSet<ScheduledMeasurementInstance<LL, MetricType<LL>>> set = new HashSet<ScheduledMeasurementInstance<LL, MetricType<LL>>>(resource.getMetrics().size());
        Collection<MeasurementInstance<LL, MetricType<LL>>> metrics = resource.getMetrics();
        for (MeasurementInstance<LL, MetricType<LL>> metric : metrics) {
            if (((MetricType)metric.getType()).isDisabled()) continue;
            ScheduledMeasurementInstance<LL, MetricType<LL>> meas = new ScheduledMeasurementInstance<LL, MetricType<LL>>(resource, metric);
            meas.setNextCollectionTime(((MetricType)metric.getType()).getInterval().millis() + now);
            set.add(meas);
        }
        return set;
    }

    public static <LL> Set<ScheduledMeasurementInstance<LL, AvailType<LL>>> createAvails(Resource<LL> resource) {
        long now = System.currentTimeMillis();
        HashSet<ScheduledMeasurementInstance<LL, AvailType<LL>>> set = new HashSet<ScheduledMeasurementInstance<LL, AvailType<LL>>>(resource.getAvails().size());
        Collection<MeasurementInstance<LL, AvailType<LL>>> avails = resource.getAvails();
        for (MeasurementInstance<LL, AvailType<LL>> avail : avails) {
            if (((AvailType)avail.getType()).isDisabled()) continue;
            ScheduledMeasurementInstance<LL, AvailType<LL>> meas = new ScheduledMeasurementInstance<LL, AvailType<LL>>(resource, avail);
            meas.setNextCollectionTime(((AvailType)avail.getType()).getInterval().millis() + now);
            set.add(meas);
        }
        return set;
    }

    public ScheduledMeasurementInstance(Resource<L> resource, MeasurementInstance<L, T> measurementInstance) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (measurementInstance == null) {
            throw new IllegalArgumentException("measurementInstance is null");
        }
        this.resource = resource;
        this.measurementInstance = measurementInstance;
        this.nextCollectionTime = ((MeasurementType)measurementInstance.getType()).getInterval().millis() + System.currentTimeMillis();
    }

    public Resource<?> getResource() {
        return this.resource;
    }

    public MeasurementInstance<L, T> getMeasurementInstance() {
        return this.measurementInstance;
    }

    public long getNextCollectionTime() {
        return this.nextCollectionTime;
    }

    public void setNextCollectionTime(long nextCollectionTime) {
        this.nextCollectionTime = nextCollectionTime = (nextCollectionTime + 999L) / 1000L * 1000L;
    }

    public void setNextCollectionTime() {
        long interval = ((MeasurementType)this.getMeasurementInstance().getType()).getInterval().millis();
        this.setNextCollectionTime(System.currentTimeMillis() + interval);
    }

    public String toString() {
        return String.format("%s: resource=[%s], measurement=[%s], nextCollectionTime=[%s]", this.getClass().getName(), this.resource, this.measurementInstance, new Date(this.nextCollectionTime));
    }

    @Override
    public int compareTo(ScheduledMeasurementInstance<L, T> smi) {
        int n;
        int n2 = this.nextCollectionTime < smi.nextCollectionTime ? -1 : (n = this.nextCollectionTime == smi.nextCollectionTime ? 0 : 1);
        if (n != 0) {
            return n;
        }
        n = this.resource.getID().getIDString().compareTo(smi.resource.getID().getIDString());
        if (n != 0) {
            return n;
        }
        return this.measurementInstance.getID().getIDString().compareTo(smi.measurementInstance.getID().getIDString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.resource.hashCode();
        result = 31 * result + this.measurementInstance.hashCode();
        result = 31 * result + (int)(this.nextCollectionTime ^ this.nextCollectionTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScheduledMeasurementInstance)) {
            return false;
        }
        ScheduledMeasurementInstance other = (ScheduledMeasurementInstance)obj;
        if (!this.resource.equals(other.resource)) {
            return false;
        }
        if (!this.measurementInstance.equals(other.measurementInstance)) {
            return false;
        }
        return this.nextCollectionTime == other.nextCollectionTime;
    }
}

