/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.metrics.client.common.MetricType;

public class MetricDataPayloadBuilderImpl
implements MetricDataPayloadBuilder {
    private Map<String, List<Map<String, Number>>> allGauges = new HashMap<String, List<Map<String, Number>>>();
    private Map<String, List<Map<String, Number>>> allCounters = new HashMap<String, List<Map<String, Number>>>();
    private Map<String, List<Map<String, Object>>> allStrings = new HashMap<String, List<Map<String, Object>>>();
    private int count = 0;
    private String tenantId = null;

    @Override
    public void addDataPoint(String key, long timestamp, double value, MetricType metricType) {
        Number valueObject;
        Map<String, List<Map<String, Number>>> map;
        switch (metricType) {
            case GAUGE: {
                map = this.allGauges;
                valueObject = value;
                break;
            }
            case COUNTER: {
                map = this.allCounters;
                valueObject = Double.valueOf(value).longValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric type: " + (Object)((Object)metricType));
            }
        }
        List<Map<String, Number>> data = map.get(key);
        if (data == null) {
            data = new ArrayList<Map<String, Number>>();
            map.put(key, data);
        }
        HashMap<String, Number> timestampAndValue = new HashMap<String, Number>(2);
        timestampAndValue.put("timestamp", timestamp);
        timestampAndValue.put("value", valueObject);
        data.add(timestampAndValue);
        ++this.count;
    }

    @Override
    public void addDataPoint(String key, long timestamp, String value) {
        List<Map<String, Object>> data = this.allStrings.get(key);
        if (data == null) {
            data = new ArrayList<Map<String, Object>>();
            this.allStrings.put(key, data);
        }
        HashMap<String, Object> timestampAndValue = new HashMap<String, Object>(2);
        timestampAndValue.put("timestamp", timestamp);
        timestampAndValue.put("value", value != null ? value : "");
        data.add(timestampAndValue);
        ++this.count;
    }

    public Map<String, List<Map<String, Object>>> toObjectPayload() {
        HashMap<String, Object> metricKeyAndData;
        HashMap<String, List<Map<String, Object>>> fullMessageObject = new HashMap<String, List<Map<String, Object>>>();
        ArrayList allOfSpecificType = new ArrayList();
        fullMessageObject.put("gauges", allOfSpecificType);
        for (Map.Entry<String, List<Map<String, Number>>> entry : this.allGauges.entrySet()) {
            metricKeyAndData = new HashMap<String, Object>(2);
            metricKeyAndData.put("id", entry.getKey());
            metricKeyAndData.put("data", entry.getValue());
            allOfSpecificType.add(metricKeyAndData);
        }
        allOfSpecificType = new ArrayList();
        fullMessageObject.put("counters", allOfSpecificType);
        for (Map.Entry<String, List<Map<String, Number>>> entry : this.allCounters.entrySet()) {
            metricKeyAndData = new HashMap(2);
            metricKeyAndData.put("id", entry.getKey());
            metricKeyAndData.put("data", entry.getValue());
            allOfSpecificType.add(metricKeyAndData);
        }
        allOfSpecificType = new ArrayList();
        fullMessageObject.put("strings", allOfSpecificType);
        for (Map.Entry<String, List<Map<String, Object>>> entry : this.allStrings.entrySet()) {
            metricKeyAndData = new HashMap(2);
            metricKeyAndData.put("id", entry.getKey());
            metricKeyAndData.put("data", entry.getValue());
            allOfSpecificType.add(metricKeyAndData);
        }
        allOfSpecificType = new ArrayList();
        fullMessageObject.put("availabilities", allOfSpecificType);
        return fullMessageObject;
    }

    @Override
    public String toPayload() {
        String jsonPayload = Util.toJson(this.toObjectPayload());
        return jsonPayload;
    }

    @Override
    public int getNumberDataPoints() {
        return this.count;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }
}

